/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.common.QName;

final class IdentityCodec
implements Codec<QName, Class<?>> {
    private final BindingRuntimeContext context;

    IdentityCodec(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public Class<?> deserialize(QName input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input must not be null.");
        return this.context.getIdentityClass(input);
    }

    public QName serialize(Class<?> input) {
        Preconditions.checkArgument((boolean)BaseIdentity.class.isAssignableFrom(input));
        return BindingReflections.findQName(input);
    }
}

