/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueContext;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.util.SharedSingletonMapTemplate;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

abstract class IdentifiableItemCodec
implements Codec<YangInstanceIdentifier.NodeIdentifierWithPredicates, InstanceIdentifier.IdentifiableItem<?, ?>> {
    private final Class<?> identifiable;
    private final QName qname;

    IdentifiableItemCodec(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable) {
        this.identifiable = Objects.requireNonNull(identifiable);
        this.qname = schema.getQName();
    }

    static IdentifiableItemCodec of(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable, Map<QName, ValueContext> keyValueContexts) {
        switch (keyValueContexts.size()) {
            case 0: {
                throw new IllegalArgumentException("Key " + keyClass + " of " + identifiable + " has no components");
            }
            case 1: {
                Map.Entry<QName, ValueContext> entry = keyValueContexts.entrySet().iterator().next();
                return new SingleKey(schema, keyClass, identifiable, entry.getKey(), entry.getValue());
            }
        }
        return new MultiKey(schema, keyClass, identifiable, keyValueContexts);
    }

    public final InstanceIdentifier.IdentifiableItem<?, ?> deserialize(YangInstanceIdentifier.NodeIdentifierWithPredicates input) {
        Identifier<?> identifier;
        try {
            identifier = this.deserializeIdentifier(input.getKeyValues());
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to deserialize " + input, e);
        }
        return InstanceIdentifier.IdentifiableItem.of(this.identifiable, identifier);
    }

    public final YangInstanceIdentifier.NodeIdentifierWithPredicates serialize(InstanceIdentifier.IdentifiableItem<?, ?> input) {
        return this.serializeIdentifier(this.qname, input.getKey());
    }

    abstract Identifier<?> deserializeIdentifier(Map<QName, Object> var1) throws Throwable;

    abstract YangInstanceIdentifier.NodeIdentifierWithPredicates serializeIdentifier(QName var1, Identifier<?> var2);

    static MethodHandle getConstructor(Class<? extends Identifier<?>> clazz) {
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] parameters = constr.getParameterTypes();
            if (clazz.equals(parameters[0])) continue;
            try {
                return MethodHandles.publicLookup().unreflectConstructor(constr);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot access constructor " + constr + " in class " + clazz, e);
            }
        }
        throw new IllegalArgumentException("Supplied class " + clazz + "does not have required constructor.");
    }

    private static final class MultiKey
    extends IdentifiableItemCodec {
        private final ImmutableOffsetMapTemplate<QName> predicateTemplate;
        private final ImmutableOffsetMap<QName, ValueContext> keyValueContexts;
        private final ImmutableList<QName> keysInBindingOrder;
        private final MethodHandle ctor;

        MultiKey(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable, Map<QName, ValueContext> keyValueContexts) {
            super(schema, keyClass, identifiable);
            MethodHandle tmpCtor = MultiKey.getConstructor(keyClass);
            MethodHandle inv = MethodHandles.spreadInvoker(tmpCtor.type(), 0);
            this.ctor = inv.asType(inv.type().changeReturnType(Identifier.class)).bindTo(tmpCtor);
            ArrayList<QName> keyDef = schema.getKeyDefinition();
            this.predicateTemplate = ImmutableOffsetMapTemplate.ordered((Collection)keyDef);
            this.keyValueContexts = this.predicateTemplate.instantiateTransformed(keyValueContexts, (key, value) -> value);
            ArrayList<QName> tmp = new ArrayList<QName>(keyDef);
            tmp.sort(Comparator.comparing(qname -> BindingMapping.getPropertyName((String)qname.getLocalName())));
            this.keysInBindingOrder = ImmutableList.copyOf(tmp.equals(keyDef) ? keyDef : tmp);
        }

        @Override
        Identifier<?> deserializeIdentifier(Map<QName, Object> keyValues) throws Throwable {
            Object[] bindingValues = new Object[this.keysInBindingOrder.size()];
            int offset = 0;
            for (QName key : this.keysInBindingOrder) {
                bindingValues[offset++] = ((ValueContext)this.keyValueContexts.get((Object)key)).deserialize(keyValues.get(key));
            }
            return this.ctor.invokeExact(bindingValues);
        }

        @Override
        YangInstanceIdentifier.NodeIdentifierWithPredicates serializeIdentifier(QName qname, Identifier<?> key) {
            Object[] values = new Object[this.keyValueContexts.size()];
            int offset = 0;
            for (ValueContext valueCtx : this.keyValueContexts.values()) {
                values[offset++] = valueCtx.getAndSerialize(key);
            }
            return new YangInstanceIdentifier.NodeIdentifierWithPredicates(qname, this.predicateTemplate.instantiateWithValues(values));
        }
    }

    private static final class SingleKey
    extends IdentifiableItemCodec {
        private static final MethodType CTOR_TYPE = MethodType.methodType(Identifier.class, Object.class);
        private final SharedSingletonMapTemplate<QName> predicateTemplate;
        private final ValueContext keyContext;
        private final MethodHandle ctor;
        private final QName keyName;

        SingleKey(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable, QName keyName, ValueContext keyContext) {
            super(schema, keyClass, identifiable);
            this.keyContext = Objects.requireNonNull(keyContext);
            this.keyName = Objects.requireNonNull(keyName);
            this.predicateTemplate = SharedSingletonMapTemplate.ordered((Object)keyName);
            this.ctor = SingleKey.getConstructor(keyClass).asType(CTOR_TYPE);
        }

        @Override
        Identifier<?> deserializeIdentifier(Map<QName, Object> keyValues) throws Throwable {
            return this.ctor.invokeExact(this.keyContext.deserialize(keyValues.get(this.keyName)));
        }

        @Override
        YangInstanceIdentifier.NodeIdentifierWithPredicates serializeIdentifier(QName qname, Identifier<?> key) {
            return new YangInstanceIdentifier.NodeIdentifierWithPredicates(qname, this.predicateTemplate.instantiateWithValue(this.keyContext.getAndSerialize(key)));
        }
    }
}

