/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DataObjectCodecContext<D extends DataObject, T extends DataNodeContainer & DocumentedNode.WithStatus>
extends DataContainerCodecContext<D, T> {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectCodecContext.class);
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, InvocationHandler.class);
    private static final MethodType DATAOBJECT_TYPE = MethodType.methodType(DataObject.class, InvocationHandler.class);
    private static final Comparator<Method> METHOD_BY_ALPHABET = Comparator.comparing(Method::getName);
    private static final Augmentations EMPTY_AUGMENTATIONS = new Augmentations(ImmutableMap.of(), ImmutableMap.of());
    private static final Method[] EMPTY_METHODS = new Method[0];
    private final ImmutableMap<String, LeafNodeCodecContext<?>> leafChild;
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, NodeContextSupplier> byYang;
    private final ImmutableMap<String, NodeContextSupplier> byMethod;
    private final ImmutableMap<String, String> nonnullToGetter;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byStreamClass;
    private final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byBindingArgClass;
    private final ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, Type> possibleAugmentations;
    private final MethodHandle proxyConstructor;
    private final Method[] propertyMethods;
    private static final AtomicReferenceFieldUpdater<DataObjectCodecContext, Augmentations> AUGMENTATIONS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DataObjectCodecContext.class, Augmentations.class, "augmentations");
    private volatile Augmentations augmentations = EMPTY_AUGMENTATIONS;
    private volatile ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> mismatchedAugmented = ImmutableMap.of();

    DataObjectCodecContext(DataContainerCodecPrototype<T> prototype) {
        super(prototype);
        Class bindingClass = this.getBindingClass();
        this.leafChild = this.factory().getLeafNodes(bindingClass, (DataNodeContainer)this.getSchema());
        Map clsToMethod = BindingReflections.getChildrenClassToMethod(bindingClass);
        HashMap<YangInstanceIdentifier.PathArgument, Object> byYangBuilder = new HashMap<YangInstanceIdentifier.PathArgument, Object>();
        HashMap<Method, Object> tmpMethodToSupplier = new HashMap<Method, Object>();
        HashMap byStreamClassBuilder = new HashMap();
        HashMap byBindingArgClassBuilder = new HashMap();
        for (LeafNodeCodecContext leafNodeCodecContext : this.leafChild.values()) {
            tmpMethodToSupplier.put(leafNodeCodecContext.getGetter(), leafNodeCodecContext);
            byYangBuilder.put(leafNodeCodecContext.getDomPathArgument(), leafNodeCodecContext);
        }
        for (Map.Entry entry : clsToMethod.entrySet()) {
            Method method = (Method)entry.getValue();
            Verify.verify((!method.isDefault() ? 1 : 0) != 0, (String)"Unexpected default method %s in %s", (Object)method, bindingClass);
            DataContainerCodecPrototype<?> childProto = this.loadChildPrototype((Class)entry.getKey());
            tmpMethodToSupplier.put(method, childProto);
            byStreamClassBuilder.put(childProto.getBindingClass(), childProto);
            byYangBuilder.put(childProto.getYangArg(), childProto);
            if (!childProto.isChoice()) continue;
            ChoiceNodeCodecContext choiceNodeCodecContext = (ChoiceNodeCodecContext)childProto.get();
            for (Class<?> clazz : choiceNodeCodecContext.getCaseChildrenClasses()) {
                byBindingArgClassBuilder.put(clazz, childProto);
            }
        }
        int methodCount = tmpMethodToSupplier.size();
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)methodCount);
        this.propertyMethods = methodCount == 0 ? EMPTY_METHODS : new Method[methodCount];
        int offset = 0;
        for (Map.Entry entry : tmpMethodToSupplier.entrySet()) {
            Method method = (Method)entry.getKey();
            this.propertyMethods[offset++] = method;
            builder.put((Object)method.getName(), entry.getValue());
        }
        Arrays.sort(this.propertyMethods, METHOD_BY_ALPHABET);
        this.byMethod = builder.build();
        this.byYang = ImmutableMap.copyOf(byYangBuilder);
        this.byStreamClass = ImmutableMap.copyOf(byStreamClassBuilder);
        byBindingArgClassBuilder.putAll((Map<Class<?>, Object>)this.byStreamClass);
        this.byBindingArgClass = ImmutableMap.copyOf(byBindingArgClassBuilder);
        Map clsToNonnull = BindingReflections.getChildrenClassToNonnullMethod(bindingClass);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : clsToNonnull.entrySet()) {
            Method method = (Method)entry.getValue();
            if (!method.isDefault()) {
                LOG.warn("Ignoring non-default method {} in {}", (Object)method, bindingClass);
                continue;
            }
            String methodName = method.getName();
            String getterName = BindingMapping.getGetterMethodForNonnull((String)methodName).intern();
            Verify.verify((boolean)this.byMethod.containsKey((Object)getterName), (String)"Cannot find getter %s for %s", (Object)getterName, (Object)methodName);
            hashMap.put(methodName, getterName);
        }
        this.nonnullToGetter = ImmutableMap.copyOf(hashMap);
        this.possibleAugmentations = Augmentable.class.isAssignableFrom(bindingClass) ? this.factory().getRuntimeContext().getAvailableAugmentationTypes((DataNodeContainer)this.getSchema()) : ImmutableMap.of();
        this.reloadAllAugmentations();
        Class<?> proxyClass = Proxy.getProxyClass(bindingClass.getClassLoader(), bindingClass, AugmentationHolder.class);
        try {
            this.proxyConstructor = MethodHandles.publicLookup().findConstructor(proxyClass, CONSTRUCTOR_TYPE).asType(DATAOBJECT_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new IllegalStateException("Failed to find contructor for class " + proxyClass, reflectiveOperationException);
        }
    }

    private void reloadAllAugmentations() {
        Augmentations oldAugmentations = this.augmentations;
        HashMap addByYang = new HashMap();
        HashMap addByStream = new HashMap();
        for (Type augment : this.possibleAugmentations.values()) {
            DataContainerCodecPrototype<?> augProto = this.getAugmentationPrototype(augment);
            if (augProto == null) continue;
            YangInstanceIdentifier.PathArgument yangArg = augProto.getYangArg();
            Class<?> bindingClass = augProto.getBindingClass();
            if (!oldAugmentations.byYang.containsKey((Object)yangArg) && addByYang.putIfAbsent(yangArg, augProto) == null) {
                LOG.trace("Discovered new YANG mapping {} -> {} in {}", new Object[]{yangArg, augProto, this});
            }
            if (oldAugmentations.byStream.containsKey(bindingClass) || addByStream.putIfAbsent(bindingClass, augProto) != null) continue;
            LOG.trace("Discovered new class mapping {} -> {} in {}", new Object[]{bindingClass, augProto, this});
        }
        while (true) {
            if (addByYang.isEmpty() && addByStream.isEmpty()) {
                LOG.trace("No new augmentations discovered in {}", (Object)this);
                return;
            }
            Augmentations newAugmentations = new Augmentations(DataObjectCodecContext.concatMaps(oldAugmentations.byYang, addByYang), DataObjectCodecContext.concatMaps(oldAugmentations.byStream, addByStream));
            if (AUGMENTATIONS_UPDATER.compareAndSet(this, oldAugmentations, newAugmentations)) {
                return;
            }
            oldAugmentations = this.augmentations;
            DataObjectCodecContext.removeMapKeys(addByYang, oldAugmentations.byYang);
            DataObjectCodecContext.removeMapKeys(addByStream, oldAugmentations.byStream);
        }
    }

    private static <K, V> ImmutableMap<K, V> concatMaps(ImmutableMap<K, V> old, Map<K, V> add) {
        if (add.isEmpty()) {
            return old;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(old.size() + add.size()));
        builder.putAll(old);
        builder.putAll(add);
        return builder.build();
    }

    private static <K, V> void removeMapKeys(Map<K, V> removeFrom, ImmutableMap<K, V> map) {
        Iterator<K> it = removeFrom.keySet().iterator();
        while (it.hasNext()) {
            if (!map.containsKey(it.next())) continue;
            it.remove();
        }
    }

    @Override
    public <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> childClass) {
        DataContainerCodecPrototype<C> childProto = this.streamChildPrototype(childClass);
        return this.childNonNull(childProto, childClass, " Child %s is not valid child.", childClass).get();
    }

    private DataContainerCodecPrototype<?> streamChildPrototype(Class<?> childClass) {
        DataContainerCodecPrototype childProto = (DataContainerCodecPrototype)this.byStreamClass.get(childClass);
        if (childProto != null) {
            return childProto;
        }
        if (Augmentation.class.isAssignableFrom(childClass)) {
            return this.augmentationByClass(childClass);
        }
        return null;
    }

    @Override
    public <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> childClass) {
        DataContainerCodecPrototype<C> childProto = this.streamChildPrototype(childClass);
        if (childProto != null) {
            return Optional.of(childProto.get());
        }
        return Optional.empty();
    }

    @Override
    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        NodeCodecContext context;
        Class argType = arg.getType();
        DataContainerCodecPrototype<?> ctxProto = (DataContainerCodecPrototype<?>)this.byBindingArgClass.get((Object)argType);
        if (ctxProto == null && Augmentation.class.isAssignableFrom(argType)) {
            ctxProto = this.augmentationByClass(argType);
        }
        if ((context = this.childNonNull(ctxProto, argType, "Class %s is not valid child of %s", argType, this.getBindingClass()).get()) instanceof ChoiceNodeCodecContext) {
            ChoiceNodeCodecContext choice = (ChoiceNodeCodecContext)context;
            choice.addYangPathArgument(arg, builder);
            Optional caseType = arg.getCaseType();
            Class type = arg.getType();
            BindingCodecTreeNode caze = caseType.isPresent() ? choice.streamChild((Class)caseType.get()) : choice.getCaseByChildClass(type);
            caze.addYangPathArgument(arg, builder);
            return caze.bindingPathArgumentChild(arg, (List)builder);
        }
        context.addYangPathArgument(arg, builder);
        return context;
    }

    @Override
    public NodeCodecContext<D> yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        NodeContextSupplier childSupplier = arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? (NodeContextSupplier)this.byYang.get((Object)new YangInstanceIdentifier.NodeIdentifier(arg.getNodeType())) : (arg instanceof YangInstanceIdentifier.AugmentationIdentifier ? this.yangAugmentationChild((YangInstanceIdentifier.AugmentationIdentifier)arg) : (NodeContextSupplier)this.byYang.get((Object)arg));
        return ((NodeContextSupplier)this.childNonNull(childSupplier, arg, "Argument %s is not valid child of %s", arg, this.getSchema())).get();
    }

    protected final LeafNodeCodecContext<?> getLeafChild(String name) {
        LeafNodeCodecContext value = (LeafNodeCodecContext)this.leafChild.get((Object)name);
        return IncorrectNestingException.checkNonNull(value, "Leaf %s is not valid for %s", name, this.getBindingClass());
    }

    private DataContainerCodecPrototype<?> loadChildPrototype(Class<?> childClass) {
        Object childSchema;
        DataSchemaNode sameName;
        DataSchemaNode origDef = this.factory().getRuntimeContext().getSchemaDefinition(childClass);
        try {
            sameName = ((DataNodeContainer)this.getSchema()).getDataChildByName(origDef.getQName());
        }
        catch (IllegalArgumentException e) {
            sameName = null;
        }
        if (sameName != null) {
            childSchema = origDef.equals(sameName) ? sameName : (origDef.equals(SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)sameName)) ? sameName : null);
        } else {
            QName instantiedName = origDef.getQName().withModule(this.namespace());
            DataSchemaNode potential = ((DataNodeContainer)this.getSchema()).getDataChildByName(instantiedName);
            childSchema = potential != null && origDef.equals(SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)potential)) ? potential : null;
        }
        DataSchemaNode nonNullChild = this.childNonNull(childSchema, childClass, "Node %s does not have child named %s", this.getSchema(), childClass);
        return DataContainerCodecPrototype.from(this.createBindingArg(childClass, nonNullChild), nonNullChild, this.factory());
    }

    InstanceIdentifier.Item<?> createBindingArg(Class<?> childClass, DataSchemaNode childSchema) {
        return InstanceIdentifier.Item.of(childClass);
    }

    private DataContainerCodecPrototype<?> yangAugmentationChild(YangInstanceIdentifier.AugmentationIdentifier arg) {
        DataContainerCodecPrototype firstTry = (DataContainerCodecPrototype)this.augmentations.byYang.get((Object)arg);
        if (firstTry != null) {
            return firstTry;
        }
        if (this.possibleAugmentations.containsKey((Object)arg)) {
            this.reloadAllAugmentations();
            return (DataContainerCodecPrototype)this.augmentations.byYang.get((Object)arg);
        }
        return null;
    }

    private @Nullable DataContainerCodecPrototype<?> augmentationByClass(@NonNull Class<?> childClass) {
        DataContainerCodecPrototype<?> lookup = this.augmentationByClassOrEquivalentClass(childClass);
        if (lookup != null || !this.isPotentialAugmentation(childClass)) {
            return lookup;
        }
        this.reloadAllAugmentations();
        lookup = this.augmentationByClassOrEquivalentClass(childClass);
        if (lookup != null) {
            return lookup;
        }
        ClassLoader loader = childClass.getClassLoader();
        if (loader == null) {
            return null;
        }
        LOG.debug("Class {} not loaded via TCCL, attempting to recover", childClass);
        ClassLoaderUtils.runWithClassLoader((ClassLoader)loader, this::reloadAllAugmentations);
        return this.augmentationByClassOrEquivalentClass(childClass);
    }

    private boolean isPotentialAugmentation(Class<?> childClass) {
        JavaTypeName name = JavaTypeName.create(childClass);
        for (Type type : this.possibleAugmentations.values()) {
            if (!name.equals(type.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private @Nullable DataContainerCodecPrototype<?> augmentationByClassOrEquivalentClass(@NonNull Class<?> childClass) {
        ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> local = this.augmentations.byStream;
        DataContainerCodecPrototype childProto = (DataContainerCodecPrototype)local.get(childClass);
        if (childProto != null) {
            return childProto;
        }
        DataContainerCodecPrototype mismatched = (DataContainerCodecPrototype)this.mismatchedAugmented.get(childClass);
        if (mismatched != null) {
            return mismatched;
        }
        Class augTarget = BindingReflections.findAugmentationTarget(childClass);
        if (this.getBindingClass().equals(augTarget)) {
            for (DataContainerCodecPrototype realChild : local.values()) {
                if (!Augmentation.class.isAssignableFrom(realChild.getBindingClass()) || !BindingReflections.isSubstitutionFor(childClass, realChild.getBindingClass())) continue;
                return this.cacheMismatched(childClass, realChild);
            }
        }
        LOG.trace("Failed to resolve {} as a valid augmentation in {}", childClass, (Object)this);
        return null;
    }

    private synchronized DataContainerCodecPrototype<?> cacheMismatched(Class<?> childClass, DataContainerCodecPrototype<?> prototype) {
        ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> local = this.mismatchedAugmented;
        DataContainerCodecPrototype existing = (DataContainerCodecPrototype)local.get(childClass);
        if (existing != null) {
            return existing;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(local.size() + 1));
        builder.putAll(local);
        builder.put(childClass, prototype);
        this.mismatchedAugmented = builder.build();
        LOG.trace("Cached mismatched augmentation {} -> {} in {}", new Object[]{childClass, prototype, this});
        return prototype;
    }

    private DataContainerCodecPrototype<?> getAugmentationPrototype(Type value) {
        Class augClass;
        ClassLoadingStrategy loader = this.factory().getRuntimeContext().getStrategy();
        try {
            augClass = loader.loadClass(value);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Failed to load augmentation prototype for {}. Will be retried when needed.", (Object)value, (Object)e);
            return null;
        }
        Map.Entry augSchema = this.factory().getRuntimeContext().getResolvedAugmentationSchema((DataNodeContainer)this.getSchema(), augClass);
        return DataContainerCodecPrototype.from(augClass, (YangInstanceIdentifier.AugmentationIdentifier)augSchema.getKey(), (AugmentationSchemaNode)augSchema.getValue(), this.factory());
    }

    @NonNull String getterNameForNonnullName(String nonnullMethod) {
        return (String)Verify.verifyNotNull((Object)this.nonnullToGetter.get((Object)nonnullMethod), (String)"Failed to look up getter method for %s", (Object[])new Object[]{nonnullMethod});
    }

    @Nullable Object getBindingChildValue(String method, NormalizedNodeContainer domData) {
        Object childContext = ((NodeContextSupplier)Verify.verifyNotNull((Object)this.byMethod.get((Object)method), (String)"Cannot find data handler for method %s", (Object[])new Object[]{method})).get();
        Optional domChild = domData.getChild(((NodeCodecContext)childContext).getDomPathArgument());
        return domChild.isPresent() ? ((NodeCodecContext)childContext).deserializeObject((NormalizedNode)domChild.get()) : ((NodeCodecContext)childContext).defaultObject();
    }

    protected final D createBindingProxy(NormalizedNodeContainer<?, ?, ?> node) {
        try {
            return (D)this.proxyConstructor.invokeExact(new LazyDataObject(this, node));
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> data) {
        HashMap map = new HashMap();
        for (NormalizedNode childValue : data.getValue()) {
            AugmentationNode augDomNode;
            DataContainerCodecPrototype<?> codecProto;
            if (!(childValue instanceof AugmentationNode) || (codecProto = this.yangAugmentationChild((augDomNode = (AugmentationNode)childValue).getIdentifier())) == null) continue;
            NodeCodecContext codec = codecProto.get();
            map.put((Class<Augmentation<?>>)((DataContainerCodecContext)codec).getBindingClass(), (Augmentation<?>)codec.deserializeObject((NormalizedNode<?, ?>)augDomNode));
        }
        for (DataContainerCodecPrototype value : this.augmentations.byStream.values()) {
            Optional augData = data.getChild(value.getYangArg());
            if (!augData.isPresent()) continue;
            map.put((Class<Augmentation<?>>)value.getBindingClass(), (Augmentation<?>)value.get().deserializeObject((NormalizedNode)augData.get()));
        }
        return map;
    }

    final Method[] propertyMethods() {
        return this.propertyMethods;
    }

    @Override
    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals(arg));
        return this.bindingArg();
    }

    @Override
    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.bindingArg().equals(arg));
        return this.getDomPathArgument();
    }

    private static final class Augmentations
    implements Immutable {
        final ImmutableMap<YangInstanceIdentifier.PathArgument, DataContainerCodecPrototype<?>> byYang;
        final ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byStream;

        Augmentations(ImmutableMap<YangInstanceIdentifier.PathArgument, DataContainerCodecPrototype<?>> byYang, ImmutableMap<Class<?>, DataContainerCodecPrototype<?>> byStream) {
            this.byYang = Objects.requireNonNull(byYang);
            this.byStream = Objects.requireNonNull(byStream);
        }
    }
}

