/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.KeyedListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class BindingToNormalizedStreamWriter
implements BindingStreamEventWriter,
Delegator<NormalizedNodeStreamWriter> {
    private final Deque<NodeCodecContext<?>> schema = new ArrayDeque();
    private final NormalizedNodeStreamWriter delegate;
    private final NodeCodecContext<?> rootNodeSchema;

    BindingToNormalizedStreamWriter(NodeCodecContext<?> rootNodeSchema, NormalizedNodeStreamWriter delegate) {
        this.rootNodeSchema = Objects.requireNonNull(rootNodeSchema);
        this.delegate = Objects.requireNonNull(delegate);
    }

    static BindingToNormalizedStreamWriter create(NodeCodecContext<?> schema, NormalizedNodeStreamWriter delegate) {
        return new BindingToNormalizedStreamWriter(schema, delegate);
    }

    private void emitSchema(Object schemaNode) {
        this.delegate.nextDataSchemaNode((DataSchemaNode)schemaNode);
    }

    NodeCodecContext<?> current() {
        return this.schema.peek();
    }

    private YangInstanceIdentifier.NodeIdentifier duplicateSchemaEnter() {
        NodeCodecContext<?> next = this.current() == null ? this.rootNodeSchema : this.current();
        this.schema.push(next);
        return (YangInstanceIdentifier.NodeIdentifier)this.current().getDomPathArgument();
    }

    private <T extends YangInstanceIdentifier.PathArgument> T enter(Class<?> name, Class<T> identifier) {
        BindingCodecTreeNode<Object> next;
        if (this.current() == null) {
            next = this.rootNodeSchema;
        } else {
            Preconditions.checkArgument((boolean)(this.current() instanceof DataContainerCodecContext), (String)"Could not start node %s", name);
            next = ((DataContainerCodecContext)this.current()).streamChild(name);
        }
        this.schema.push((NodeCodecContext<?>)next);
        YangInstanceIdentifier.PathArgument arg = next.getDomPathArgument();
        return (T)arg;
    }

    private <T extends YangInstanceIdentifier.PathArgument> T enter(String localName, Class<T> identifier) {
        NodeCodecContext<?> current = this.current();
        LeafNodeCodecContext<?> next = ((DataObjectCodecContext)current).getLeafChild(localName);
        this.schema.push(next);
        YangInstanceIdentifier.PathArgument arg = ((NodeCodecContext)next).getDomPathArgument();
        return (T)arg;
    }

    public NormalizedNodeStreamWriter getDelegate() {
        return this.delegate;
    }

    public void endNode() throws IOException {
        NodeCodecContext<?> left = this.schema.pop();
        if (!(left instanceof CaseNodeCodecContext)) {
            this.getDelegate().endNode();
        }
    }

    private Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> serializeLeaf(String localName, Object value) {
        Preconditions.checkArgument((boolean)(this.current() instanceof DataObjectCodecContext));
        DataObjectCodecContext currentCasted = (DataObjectCodecContext)this.current();
        LeafNodeCodecContext<?> leafContext = currentCasted.getLeafChild(localName);
        YangInstanceIdentifier.NodeIdentifier domArg = (YangInstanceIdentifier.NodeIdentifier)leafContext.getDomPathArgument();
        Object domValue = leafContext.getValueCodec().serialize(value);
        this.emitSchema(leafContext.getSchema());
        return new AbstractMap.SimpleEntry<YangInstanceIdentifier.NodeIdentifier, Object>(domArg, domValue);
    }

    public void leafNode(String localName, Object value) throws IOException {
        Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> dom = this.serializeLeaf(localName, value);
        this.getDelegate().leafNode(dom.getKey(), dom.getValue());
    }

    public void anyxmlNode(String name, Object value) throws IOException {
        Map.Entry<YangInstanceIdentifier.NodeIdentifier, Object> dom = this.serializeLeaf(name, value);
        this.getDelegate().anyxmlNode(dom.getKey(), dom.getValue());
    }

    public void leafSetEntryNode(Object value) throws IOException {
        LeafNodeCodecContext ctx = (LeafNodeCodecContext)this.current();
        this.getDelegate().leafSetEntryNode(ctx.getSchema().getQName(), ctx.getValueCodec().serialize(value));
    }

    public void startAugmentationNode(Class<? extends Augmentation<?>> augmentationType) throws IOException {
        this.getDelegate().startAugmentationNode(this.enter(augmentationType, YangInstanceIdentifier.AugmentationIdentifier.class));
    }

    public void startCase(Class<? extends DataObject> caze, int childSizeHint) {
        this.enter(caze, YangInstanceIdentifier.NodeIdentifier.class);
    }

    public void startChoiceNode(Class<? extends DataContainer> type, int childSizeHint) throws IOException {
        this.getDelegate().startChoiceNode(this.enter(type, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startContainerNode(Class<? extends DataObject> object, int childSizeHint) throws IOException {
        this.getDelegate().startContainerNode(this.enter(object, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startLeafSet(String localName, int childSizeHint) throws IOException {
        YangInstanceIdentifier.NodeIdentifier id = this.enter(localName, YangInstanceIdentifier.NodeIdentifier.class);
        this.emitSchema(this.current().getSchema());
        this.getDelegate().startLeafSet(id, childSizeHint);
    }

    public void startOrderedLeafSet(String localName, int childSizeHint) throws IOException {
        this.getDelegate().startOrderedLeafSet(this.enter(localName, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startMapEntryNode(Identifier<?> key, int childSizeHint) throws IOException {
        this.duplicateSchemaEnter();
        YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = ((KeyedListNodeCodecContext)this.current()).serialize(key);
        this.getDelegate().startMapEntryNode(identifier, childSizeHint);
    }

    public <T extends DataObject & Identifiable<?>> void startMapNode(Class<T> mapEntryType, int childSizeHint) throws IOException {
        this.getDelegate().startMapNode(this.enter(mapEntryType, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public <T extends DataObject & Identifiable<?>> void startOrderedMapNode(Class<T> mapEntryType, int childSizeHint) throws IOException {
        this.getDelegate().startOrderedMapNode(this.enter(mapEntryType, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startUnkeyedList(Class<? extends DataObject> obj, int childSizeHint) throws IOException {
        this.getDelegate().startUnkeyedList(this.enter(obj, YangInstanceIdentifier.NodeIdentifier.class), childSizeHint);
    }

    public void startUnkeyedListItem(int childSizeHint) throws IOException {
        this.getDelegate().startUnkeyedListItem(this.duplicateSchemaEnter(), childSizeHint);
    }

    public void flush() throws IOException {
        this.getDelegate().flush();
    }

    public void close() throws IOException {
        this.getDelegate().close();
    }
}

