/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeWriterFactory;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.dom.codec.util.AbstractBindingLazyContainerNode;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializer;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerImplementation;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerRegistry;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingNormalizedNodeCodecRegistry
implements DataObjectSerializerRegistry,
BindingCodecTreeFactory,
BindingNormalizedNodeWriterFactory,
BindingNormalizedNodeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(BindingNormalizedNodeCodecRegistry.class);
    private final DataObjectSerializerGenerator generator;
    private final LoadingCache<Class<? extends DataObject>, DataObjectSerializer> serializers;
    private volatile BindingCodecContext codecContext;

    public BindingNormalizedNodeCodecRegistry(DataObjectSerializerGenerator generator) {
        this.generator = Objects.requireNonNull(generator);
        this.serializers = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new GeneratorLoader());
    }

    public DataObjectSerializer getSerializer(Class<? extends DataObject> type) {
        return (DataObjectSerializer)this.serializers.getUnchecked(type);
    }

    public BindingCodecTree getCodecContext() {
        return this.codecContext;
    }

    public void onBindingRuntimeContextUpdated(BindingRuntimeContext context) {
        this.codecContext = new BindingCodecContext(context, this);
        this.generator.onBindingRuntimeContextUpdated(context);
    }

    @Override
    public YangInstanceIdentifier toYangInstanceIdentifier(InstanceIdentifier<?> binding) {
        return this.codecContext.getInstanceIdentifierCodec().serialize(binding);
    }

    public InstanceIdentifier<?> fromYangInstanceIdentifier(YangInstanceIdentifier dom) {
        return this.codecContext.getInstanceIdentifierCodec().deserialize(dom);
    }

    @Override
    public <T extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalizedNode(InstanceIdentifier<T> path, T data) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> writeCtx = this.codecContext.newWriter(path, domWriter);
        try {
            this.getSerializer(path.getTargetType()).serialize(data, writeCtx.getValue());
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing path {} data {}", new Object[]{path, data, e});
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        return new AbstractMap.SimpleEntry(writeCtx.getKey(), result.getResult());
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeNotification(Notification data) {
        return this.serializeDataObject((DataObject)data, (iface, domWriter) -> this.newNotificationWriter((Class<? extends Notification>)iface.asSubclass(Notification.class), (NormalizedNodeStreamWriter)domWriter));
    }

    @Override
    public ContainerNode toNormalizedNodeRpcData(DataContainer data) {
        return this.serializeDataObject((DataObject)data, this::newRpcWriter);
    }

    @Override
    public ContainerNode toNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, RpcInput input) {
        return this.serializeDataObject((DataObject)input, (iface, domWriter) -> this.newActionInputWriter(action, (NormalizedNodeStreamWriter)domWriter));
    }

    @Override
    public ContainerNode toNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, RpcOutput output) {
        return this.serializeDataObject((DataObject)output, (iface, domWriter) -> this.newActionOutputWriter(action, (NormalizedNodeStreamWriter)domWriter));
    }

    @Override
    public BindingLazyContainerNode<RpcInput> toLazyNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcInput input) {
        return new LazyActionInputContainerNode(identifier, input, this, action);
    }

    @Override
    public BindingLazyContainerNode<RpcOutput> toLazyNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcOutput output) {
        return new LazyActionOutputContainerNode(identifier, output, this, action);
    }

    private <T extends DataContainer> ContainerNode serializeDataObject(DataObject data, BiFunction<Class<? extends T>, NormalizedNodeStreamWriter, BindingStreamEventWriter> newWriter) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        Class type = data.getImplementedInterface();
        BindingStreamEventWriter writer = newWriter.apply(type, domWriter);
        try {
            this.getSerializer(type).serialize(data, writer);
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing data {}", (Object)data, (Object)e);
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        return (ContainerNode)result.getResult();
    }

    private static boolean isBindingRepresentable(NormalizedNode<?, ?> data) {
        if (data instanceof ChoiceNode) {
            return false;
        }
        if (data instanceof LeafNode) {
            return false;
        }
        if (data instanceof LeafSetNode) {
            return false;
        }
        if (data instanceof LeafSetEntryNode) {
            return false;
        }
        if (data instanceof MapNode) {
            return false;
        }
        return !(data instanceof UnkeyedListNode);
    }

    @Override
    public Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        if (!BindingNormalizedNodeCodecRegistry.isBindingRepresentable(data)) {
            return null;
        }
        ArrayList<InstanceIdentifier.PathArgument> builder = new ArrayList<InstanceIdentifier.PathArgument>();
        NodeCodecContext<?> codec = this.codecContext.getCodecContextNode(path, builder);
        if (codec == null) {
            if (data != null) {
                LOG.warn("Path {} does not have a binding equivalent, should have been caught earlier ({})", (Object)path, data.getClass());
            }
            return null;
        }
        Object lazyObj = codec.deserialize(data);
        InstanceIdentifier bindingPath = InstanceIdentifier.create(builder);
        return new AbstractMap.SimpleEntry((InstanceIdentifier<?>)bindingPath, (DataObject)lazyObj);
    }

    @Override
    public Notification fromNormalizedNodeNotification(SchemaPath path, ContainerNode data) {
        NotificationCodecContext<?> codec = this.codecContext.getNotificationContext(path);
        return (Notification)codec.deserialize((NormalizedNode<?, ?>)data);
    }

    @Override
    public DataObject fromNormalizedNodeRpcData(SchemaPath path, ContainerNode data) {
        RpcInputCodec<?> codec = this.codecContext.getRpcInputCodec(path);
        return codec.deserialize((NormalizedNode<?, ?>)data);
    }

    @Override
    public <T extends RpcInput> T fromNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, ContainerNode input) {
        return (T)((RpcInput)Objects.requireNonNull(this.codecContext.getActionCodec(action).input().deserialize((NormalizedNode)Objects.requireNonNull(input))));
    }

    @Override
    public <T extends RpcOutput> T fromNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, ContainerNode output) {
        return (T)((RpcOutput)Objects.requireNonNull(this.codecContext.getActionCodec(action).output().deserialize((NormalizedNode)Objects.requireNonNull(output))));
    }

    @Override
    public Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> newWriterAndIdentifier(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        return this.codecContext.newWriter(path, domWriter);
    }

    @Override
    public BindingStreamEventWriter newWriter(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        return this.codecContext.newWriterWithoutIdentifier(path, domWriter);
    }

    @Override
    public BindingStreamEventWriter newNotificationWriter(Class<? extends Notification> notification, NormalizedNodeStreamWriter streamWriter) {
        return this.codecContext.newNotificationWriter(notification, streamWriter);
    }

    @Override
    public BindingStreamEventWriter newActionInputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return this.codecContext.getActionCodec(action).input().createWriter(domWriter);
    }

    @Override
    public BindingStreamEventWriter newActionOutputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return this.codecContext.getActionCodec(action).output().createWriter(domWriter);
    }

    @Override
    public BindingStreamEventWriter newRpcWriter(Class<? extends DataContainer> rpcInputOrOutput, NormalizedNodeStreamWriter streamWriter) {
        return this.codecContext.newRpcWriter(rpcInputOrOutput, streamWriter);
    }

    public <T extends DataObject> Function<Optional<NormalizedNode<?, ?>>, Optional<T>> deserializeFunction(InstanceIdentifier<T> path) {
        DataObjectCodecContext ctx = (DataObjectCodecContext)this.codecContext.getCodecContextNode(path, null);
        return new DeserializeFunction(ctx);
    }

    @Override
    public BindingCodecTree create(BindingRuntimeContext context) {
        return new BindingCodecContext(context, this);
    }

    @Override
    public BindingCodecTree create(SchemaContext context, Class<?> ... bindingClasses) {
        ModuleInfoBackedContext strategy = ModuleInfoBackedContext.create();
        for (Class<?> bindingCls : bindingClasses) {
            try {
                strategy.registerModuleInfo(BindingReflections.getModuleInfo(bindingCls));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create BindingRuntimeContext from class " + bindingCls.getName(), e);
            }
        }
        BindingRuntimeContext runtimeCtx = BindingRuntimeContext.create((ClassLoadingStrategy)strategy, (SchemaContext)context);
        return this.create(runtimeCtx);
    }

    @NonNullByDefault
    private static final class LazyActionOutputContainerNode
    extends AbstractLazyActionContainerNode<RpcOutput> {
        LazyActionOutputContainerNode(YangInstanceIdentifier.NodeIdentifier identifier, RpcOutput bindingData, BindingNormalizedNodeCodecRegistry context, Class<? extends Action<?, ?, ?>> action) {
            super(identifier, bindingData, context, action);
        }

        @Override
        protected ContainerNode computeContainerNode(BindingNormalizedNodeCodecRegistry context) {
            return context.toNormalizedNodeActionOutput(this.action, (RpcOutput)this.getDataObject());
        }
    }

    @NonNullByDefault
    private static final class LazyActionInputContainerNode
    extends AbstractLazyActionContainerNode<RpcInput> {
        LazyActionInputContainerNode(YangInstanceIdentifier.NodeIdentifier identifier, RpcInput bindingData, BindingNormalizedNodeCodecRegistry context, Class<? extends Action<?, ?, ?>> action) {
            super(identifier, bindingData, context, action);
        }

        @Override
        protected ContainerNode computeContainerNode(BindingNormalizedNodeCodecRegistry context) {
            return context.toNormalizedNodeActionInput(this.action, (RpcInput)this.getDataObject());
        }
    }

    @NonNullByDefault
    private static abstract class AbstractLazyActionContainerNode<T extends DataObject>
    extends AbstractBindingLazyContainerNode<T, BindingNormalizedNodeCodecRegistry> {
        protected final Class<? extends Action<?, ?, ?>> action;

        AbstractLazyActionContainerNode(YangInstanceIdentifier.NodeIdentifier identifier, T bindingData, BindingNormalizedNodeCodecRegistry context, Class<? extends Action<?, ?, ?>> action) {
            super(identifier, bindingData, context);
            this.action = Objects.requireNonNull(action);
        }
    }

    private final class DataObjectSerializerProxy
    implements DataObjectSerializer,
    Delegator<DataObjectSerializerImplementation> {
        private final DataObjectSerializerImplementation delegate;

        DataObjectSerializerProxy(DataObjectSerializerImplementation delegate) {
            this.delegate = delegate;
        }

        public DataObjectSerializerImplementation getDelegate() {
            return this.delegate;
        }

        public void serialize(DataObject obj, BindingStreamEventWriter stream) throws IOException {
            this.delegate.serialize((DataObjectSerializerRegistry)BindingNormalizedNodeCodecRegistry.this, obj, stream);
        }
    }

    private final class GeneratorLoader
    extends CacheLoader<Class<? extends DataContainer>, DataObjectSerializer> {
        private GeneratorLoader() {
        }

        public DataObjectSerializer load(Class<? extends DataContainer> key) {
            DataObjectSerializerImplementation prototype = BindingNormalizedNodeCodecRegistry.this.generator.getSerializer(key);
            return new DataObjectSerializerProxy(prototype);
        }
    }

    private static final class DeserializeFunction<T>
    implements Function<Optional<NormalizedNode<?, ?>>, Optional<T>> {
        private final DataObjectCodecContext<?, ?> ctx;

        DeserializeFunction(DataObjectCodecContext<?, ?> ctx) {
            this.ctx = ctx;
        }

        @Override
        public Optional<T> apply(Optional<NormalizedNode<?, ?>> input) {
            return input.map(data -> this.ctx.deserialize((NormalizedNode<?, ?>)data));
        }
    }
}

