/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractBindingNormalizedNodeCacheHolder;
import org.opendaylight.mdsal.binding.dom.codec.impl.CachingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class BindingNormalizedNodeCache
extends CacheLoader<DataObject, NormalizedNode<?, ?>> {
    private final LoadingCache<DataObject, NormalizedNode<?, ?>> cache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)this);
    final DataContainerCodecContext<?, ?> subtreeRoot;
    final AbstractBindingNormalizedNodeCacheHolder cacheHolder;

    BindingNormalizedNodeCache(AbstractBindingNormalizedNodeCacheHolder cacheHolder, DataContainerCodecContext<?, ?> subtreeRoot) {
        this.cacheHolder = Objects.requireNonNull(cacheHolder, "cacheHolder");
        this.subtreeRoot = Objects.requireNonNull(subtreeRoot, "subtreeRoot");
    }

    public NormalizedNode<?, ?> load(DataObject key) throws Exception {
        return CachingNormalizedNodeSerializer.serializeUsingStreamWriter(this.cacheHolder, this.subtreeRoot, key);
    }

    NormalizedNode<?, ?> get(DataObject obj) {
        return (NormalizedNode)this.cache.getUnchecked((Object)obj);
    }
}

