/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.gen.spi;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.codec.gen.spi.StaticConstantDefinition;
import org.opendaylight.mdsal.binding.model.api.Type;

public abstract class AbstractSource {
    private final Set<StaticConstantDefinition> staticConstants = new HashSet<StaticConstantDefinition>();

    public final <T> void staticConstant(String name, Class<T> type, T value) {
        this.staticConstants.add(new StaticConstantDefinition(name, type, value));
    }

    public final Set<StaticConstantDefinition> getStaticConstants() {
        return Collections.unmodifiableSet(this.staticConstants);
    }

    private static StringBuilder commonInvoke(CharSequence object, String methodName) {
        StringBuilder sb = new StringBuilder();
        if (object != null) {
            sb.append(object);
            sb.append('.');
        }
        return sb.append(methodName).append('(');
    }

    protected static final CharSequence invoke(CharSequence object, String methodName, Object arg) {
        return AbstractSource.commonInvoke(object, methodName).append(arg).append(')');
    }

    protected static final CharSequence invoke(CharSequence object, String methodName, Object ... args) {
        StringBuilder sb = AbstractSource.commonInvoke(object, methodName);
        UnmodifiableIterator iterator = Iterators.forArray((Object[])args);
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.append(')');
    }

    protected static final CharSequence assign(String var, CharSequence value) {
        return AbstractSource.assign((String)null, var, value);
    }

    protected static final CharSequence assign(String type, String var, CharSequence value) {
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append(type);
            sb.append(' ');
        }
        return sb.append(var).append(" = ").append(value);
    }

    protected static final CharSequence assign(Type type, String var, CharSequence value) {
        return AbstractSource.assign(type.getFullyQualifiedName(), var, value);
    }

    protected static final CharSequence cast(Type type, CharSequence value) {
        return AbstractSource.cast(type.getFullyQualifiedName(), value);
    }

    protected static final CharSequence cast(String type, CharSequence value) {
        return "((" + type + ") " + value + ')';
    }

    protected static final CharSequence forEach(String iterable, String iteratorName, String valueType, String valueName, CharSequence body) {
        StringBuilder sb = new StringBuilder();
        sb.append(AbstractSource.statement(AbstractSource.assign(Iterator.class.getName(), iteratorName, AbstractSource.invoke((CharSequence)iterable, "iterator", new Object[0]))));
        sb.append("while (").append(AbstractSource.invoke((CharSequence)iteratorName, "hasNext", new Object[0])).append(") {\n");
        sb.append(AbstractSource.statement(AbstractSource.assign(valueType, valueName, AbstractSource.cast(valueType, AbstractSource.invoke((CharSequence)iteratorName, "next", new Object[0])))));
        sb.append(body);
        return sb.append("\n}\n");
    }

    protected static final CharSequence statement(CharSequence statement) {
        return new StringBuilder(statement).append(";\n");
    }
}

