/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.gen.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Map;
import java.util.Objects;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.AbstractGenerator;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerGenerator;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerPrototype;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerSource;
import org.opendaylight.mdsal.binding.dom.codec.gen.spi.StaticConstantDefinition;
import org.opendaylight.mdsal.binding.dom.codec.util.AugmentableDispatchSerializer;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.util.Types;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerImplementation;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerRegistry;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStreamWriterGenerator
extends AbstractGenerator
implements DataObjectSerializerGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStreamWriterGenerator.class);
    protected static final String SERIALIZE_METHOD_NAME = "serialize";
    protected static final AugmentableDispatchSerializer AUGMENTABLE = new AugmentableDispatchSerializer();
    private static final Field FIELD_MODIFIERS = AbstractStreamWriterGenerator.getModifiersField();
    private final LoadingCache<Class<?>, DataObjectSerializerImplementation> implementations;
    private final CtClass[] serializeArguments;
    private final JavassistUtils javassist;
    private BindingRuntimeContext context;

    private static Field getModifiersField() {
        Field field;
        try {
            field = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOG.warn("Could not get modifiers field, serializers run at decreased efficiency", (Throwable)e);
            return null;
        }
        try {
            AccessController.doPrivileged(() -> {
                field.setAccessible(true);
                return null;
            });
        }
        catch (SecurityException e) {
            LOG.warn("Could not get access to modifiers field, serializers run at decreased efficiency", (Throwable)e);
            return null;
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractStreamWriterGenerator(JavassistUtils utils) {
        JavassistUtils javassistUtils = this.javassist = Objects.requireNonNull(utils, "JavassistUtils instance is required.");
        synchronized (javassistUtils) {
            this.serializeArguments = new CtClass[]{this.javassist.asCtClass(DataObjectSerializerRegistry.class), this.javassist.asCtClass(DataObject.class), this.javassist.asCtClass(BindingStreamEventWriter.class)};
            this.javassist.appendClassLoaderIfMissing(DataObjectSerializerPrototype.class.getClassLoader());
        }
        this.implementations = CacheBuilder.newBuilder().removalListener(notification -> LOG.debug("onRemoval: cause={}, wasEvicted={}", (Object)notification.getCause(), (Object)notification.wasEvicted())).weakKeys().build((CacheLoader)new SerializerImplementationLoader());
        LOG.debug("AbstractStreamWriterGenerator constructor, new instance: {}", (Object)this);
    }

    @Override
    public final DataObjectSerializerImplementation getSerializer(Class<?> type) {
        return (DataObjectSerializerImplementation)this.implementations.getUnchecked(type);
    }

    @Override
    public final void onBindingRuntimeContextUpdated(BindingRuntimeContext runtime) {
        this.context = runtime;
        LOG.debug("onBindingRuntimeContextUpdated() : {}", (Object)runtime);
    }

    @Override
    protected final String loadSerializerFor(Class<?> cls) {
        return this.getSerializer(cls).getClass().getName();
    }

    private DataObjectSerializerSource generateEmitterSource(Class<?> type, String serializerName) {
        DataObjectSerializerSource source;
        Types.typeForClass(type);
        this.javassist.appendClassLoaderIfMissing(type.getClassLoader());
        Map.Entry typeWithSchema = this.context.getTypeWithSchema(type);
        GeneratedType generatedType = (GeneratedType)typeWithSchema.getKey();
        DocumentedNode.WithStatus schema = (DocumentedNode.WithStatus)typeWithSchema.getValue();
        if (schema instanceof ContainerSchemaNode) {
            source = this.generateContainerSerializer(generatedType, (ContainerSchemaNode)schema);
        } else if (schema instanceof ListSchemaNode) {
            ListSchemaNode casted = (ListSchemaNode)schema;
            source = casted.getKeyDefinition().isEmpty() ? this.generateUnkeyedListEntrySerializer(generatedType, casted) : this.generateMapEntrySerializer(generatedType, casted);
        } else if (schema instanceof AugmentationSchemaNode) {
            source = this.generateSerializer(generatedType, (AugmentationSchemaNode)schema);
        } else if (schema instanceof CaseSchemaNode) {
            source = this.generateCaseSerializer(generatedType, (CaseSchemaNode)schema);
        } else if (schema instanceof NotificationDefinition) {
            source = this.generateNotificationSerializer(generatedType, (NotificationDefinition)schema);
        } else {
            throw new UnsupportedOperationException("Schema type " + schema.getClass() + " is not supported");
        }
        return source;
    }

    private CtClass generateEmitter0(Class<?> type, DataObjectSerializerSource source, String serializerName) {
        CtClass product;
        String body = ((CharSequence)ClassLoaderUtils.getWithClassLoader((ClassLoader)type.getClassLoader(), source::getSerializerBody)).toString();
        try {
            product = this.javassist.instantiatePrototype(DataObjectSerializerPrototype.class.getName(), serializerName, cls -> {
                for (StaticConstantDefinition def : source.getStaticConstants()) {
                    CtField field = new CtField(this.javassist.asCtClass(def.getType()), def.getName(), cls);
                    field.setModifiers(10);
                    cls.addField(field);
                }
                CtMethod serializeTo = cls.getDeclaredMethod(SERIALIZE_METHOD_NAME, this.serializeArguments);
                serializeTo.setBody(body);
                cls.setModifiers(Modifier.setPublic((int)cls.getModifiers()));
            });
        }
        catch (CannotCompileException | NotFoundException e) {
            LOG.error("Failed to instatiate serializer {}", (Object)source, (Object)e);
            throw new LinkageError("Unexpected instantation problem: serializer prototype not found", e);
        }
        return product;
    }

    protected abstract DataObjectSerializerSource generateContainerSerializer(GeneratedType var1, ContainerSchemaNode var2);

    protected abstract DataObjectSerializerSource generateCaseSerializer(GeneratedType var1, CaseSchemaNode var2);

    protected abstract DataObjectSerializerSource generateMapEntrySerializer(GeneratedType var1, ListSchemaNode var2);

    protected abstract DataObjectSerializerSource generateUnkeyedListEntrySerializer(GeneratedType var1, ListSchemaNode var2);

    protected abstract DataObjectSerializerSource generateSerializer(GeneratedType var1, AugmentationSchemaNode var2);

    protected abstract DataObjectSerializerSource generateNotificationSerializer(GeneratedType var1, NotificationDefinition var2);

    private final class SerializerImplementationLoader
    extends CacheLoader<Class<?>, DataObjectSerializerImplementation> {
        private static final String GETINSTANCE_METHOD_NAME = "getInstance";
        private static final String SERIALIZER_SUFFIX = "$StreamWriter";

        private SerializerImplementationLoader() {
        }

        private String getSerializerName(Class<?> type) {
            return type.getName() + SERIALIZER_SUFFIX;
        }

        public DataObjectSerializerImplementation load(Class<?> type) throws Exception {
            Class<? extends DataObjectSerializerImplementation> cls;
            Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(type));
            Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(type), (String)"DataContainer is not assingnable from %s from classloader %s.", type, (Object)type.getClassLoader());
            String serializerName = this.getSerializerName(type);
            try {
                cls = ClassLoaderUtils.loadClass((ClassLoader)type.getClassLoader(), (String)serializerName);
            }
            catch (ClassNotFoundException e) {
                cls = this.generateSerializer(type, serializerName);
            }
            DataObjectSerializerImplementation obj = (DataObjectSerializerImplementation)cls.getDeclaredMethod(GETINSTANCE_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
            LOG.trace("Loaded serializer {} for class {}", (Object)obj, type);
            return obj;
        }

        private Class<? extends DataObjectSerializerImplementation> generateSerializer(Class<?> type, String serializerName) throws CannotCompileException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, NoSuchFieldException {
            LOG.debug("generateSerializer() due to Cache miss: typeName={}, typeClassLoader={}, serializerName={}", new Object[]{type.getTypeName(), type.getClassLoader(), serializerName});
            DataObjectSerializerSource source = AbstractStreamWriterGenerator.this.generateEmitterSource(type, serializerName);
            CtClass poolClass = AbstractStreamWriterGenerator.this.generateEmitter0(type, source, serializerName);
            Class<DataObjectSerializerImplementation> cls = poolClass.toClass(type.getClassLoader(), type.getProtectionDomain()).asSubclass(DataObjectSerializerImplementation.class);
            for (StaticConstantDefinition constant : source.getStaticConstants()) {
                Field field = cls.getDeclaredField(constant.getName());
                field.setAccessible(true);
                field.set(null, constant.getValue());
                if (FIELD_MODIFIERS == null) continue;
                FIELD_MODIFIERS.setInt(field, field.getModifiers() | 0x10);
            }
            return cls;
        }
    }
}

