/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.GraphDecorator;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DelegateForest<V, E>
extends GraphDecorator<V, E>
implements Forest<V, E> {
    public DelegateForest() {
        this(new DirectedSparseGraph());
    }

    public DelegateForest(DirectedGraph<V, E> delegate) {
        super(delegate);
    }

    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        if (!this.delegate.getVertices().contains(v1)) {
            throw new IllegalArgumentException("Tree must already contain " + v1);
        }
        if (this.delegate.getVertices().contains(v2)) {
            throw new IllegalArgumentException("Tree must not already contain " + v2);
        }
        return this.delegate.addEdge(e, v1, v2, edgeType);
    }

    public boolean addVertex(V vertex) {
        this.setRoot(vertex);
        return true;
    }

    public boolean removeEdge(E edge) {
        return this.removeEdge(edge, true);
    }

    public boolean removeEdge(E edge, boolean remove_subtree) {
        if (!this.delegate.containsEdge(edge)) {
            return false;
        }
        Object child = this.getDest(edge);
        if (remove_subtree) {
            return this.removeVertex(child);
        }
        this.delegate.removeEdge(edge);
        return false;
    }

    public boolean removeVertex(V vertex) {
        return this.removeVertex(vertex, true);
    }

    public boolean removeVertex(V vertex, boolean remove_subtrees) {
        if (!this.delegate.containsVertex(vertex)) {
            return false;
        }
        if (remove_subtrees) {
            for (Object v : new ArrayList(this.delegate.getSuccessors(vertex))) {
                this.removeVertex(v, true);
            }
        }
        return this.delegate.removeVertex(vertex);
    }

    public List<V> getPath(V child) {
        if (!this.delegate.containsVertex(child)) {
            return null;
        }
        ArrayList<V> list = new ArrayList<V>();
        list.add(child);
        V parent = this.getParent(child);
        while (parent != null) {
            list.add(list.size(), parent);
            parent = this.getParent(parent);
        }
        return list;
    }

    public V getParent(V child) {
        if (!this.delegate.containsVertex(child)) {
            return null;
        }
        Collection parents = this.delegate.getPredecessors(child);
        if (parents.size() > 0) {
            return (V)parents.iterator().next();
        }
        return null;
    }

    public V getRoot() {
        V root = null;
        for (Object v : this.delegate.getVertices()) {
            if (this.delegate.getPredecessorCount(v) != 0) continue;
            if (root == null) {
                root = (V)v;
                continue;
            }
            return null;
        }
        return root;
    }

    public void setRoot(V root) {
        this.delegate.addVertex(root);
    }

    public boolean removeChild(V orphan) {
        return this.removeVertex(orphan);
    }

    public int getDepth(V v) {
        return this.getPath(v).size();
    }

    public int getHeight() {
        int height = 0;
        for (Object v : this.getVertices()) {
            height = Math.max(height, this.getDepth(v));
        }
        return height;
    }

    public boolean isInternal(V v) {
        return !this.isLeaf(v) && !this.isRoot(v);
    }

    public boolean isLeaf(V v) {
        return this.getChildren(v).size() == 0;
    }

    public Collection<V> getChildren(V v) {
        return this.delegate.getSuccessors(v);
    }

    public boolean isRoot(V v) {
        return this.getParent(v) == null;
    }

    public int getIncidentCount(E edge) {
        return 2;
    }

    public boolean addEdge(E edge, Collection<? extends V> vertices) {
        Pair pair = null;
        pair = vertices instanceof Pair ? (Pair)vertices : new Pair(vertices);
        return this.addEdge(edge, pair.getFirst(), pair.getSecond());
    }

    public Collection<V> getRoots() {
        HashSet roots = new HashSet();
        for (Object v : this.delegate.getVertices()) {
            if (this.delegate.getPredecessorCount(v) != 0) continue;
            roots.add(v);
        }
        return roots;
    }

    public Collection<Tree<V, E>> getTrees() {
        HashSet trees = new HashSet();
        for (V v : this.getRoots()) {
            DelegateTree tree = new DelegateTree();
            tree.addVertex(v);
            TreeUtils.growSubTree((Forest)this, tree, v);
            trees.add(tree);
        }
        return trees;
    }

    public void addTree(Tree<V, E> tree) {
        TreeUtils.addSubTree((Forest)this, tree, null, null);
    }

    public int getChildCount(V vertex) {
        return this.delegate.getSuccessorCount(vertex);
    }

    public Collection<E> getChildEdges(V vertex) {
        return this.delegate.getOutEdges(vertex);
    }

    public E getParentEdge(V vertex) {
        if (this.isRoot(vertex)) {
            return null;
        }
        return this.delegate.getInEdges(vertex).iterator().next();
    }
}

