/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netconf.mdsal.monitoring;

import java.util.Collections;
import java.util.Set;
import org.opendaylight.controller.config.yang.netconf.mdsal.monitoring.GetSchema;
import org.opendaylight.controller.config.yang.netconf.mdsal.monitoring.MonitoringToMdsalWriter;
import org.opendaylight.controller.sal.common.util.NoopAutoCloseable;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.mapping.api.NetconfOperation;
import org.opendaylight.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactoryListener;

public class MdsalMonitoringMapperFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private final MonitoringToMdsalWriter monitoringToMdsalWriter;
    private final NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener;
    private final NetconfMonitoringService netconfMonitoringService;
    private static final Set<Capability> CAPABILITIES = Collections.emptySet();

    public MdsalMonitoringMapperFactory(NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener, NetconfMonitoringService netconfMonitoringService, MonitoringToMdsalWriter monitoringToMdsalWriter) {
        this.netconfOperationServiceFactoryListener = netconfOperationServiceFactoryListener;
        this.netconfMonitoringService = netconfMonitoringService;
        this.monitoringToMdsalWriter = monitoringToMdsalWriter;
        this.netconfOperationServiceFactoryListener.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    public NetconfOperationService createService(final String netconfSessionIdForReporting) {
        return new NetconfOperationService(){

            public Set<NetconfOperation> getNetconfOperations() {
                return Collections.singleton(new GetSchema(netconfSessionIdForReporting, MdsalMonitoringMapperFactory.this.netconfMonitoringService));
            }

            public void close() {
            }
        };
    }

    public Set<Capability> getCapabilities() {
        return CAPABILITIES;
    }

    public AutoCloseable registerCapabilityListener(CapabilityListener listener) {
        return NoopAutoCloseable.INSTANCE;
    }

    @Override
    public void close() {
        this.monitoringToMdsalWriter.close();
        this.netconfOperationServiceFactoryListener.onRemoveNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }
}

