/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netconf.mdsal.monitoring;

import java.util.HashMap;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class GetSchema
extends AbstractSingletonNetconfOperation {
    private static final String GET_SCHEMA = "get-schema";
    private static final String IDENTIFIER = "identifier";
    private static final String VERSION = "version";
    private static final Logger LOG = LoggerFactory.getLogger(GetSchema.class);
    private final NetconfMonitoringService cap;

    public GetSchema(String netconfSessionIdForReporting, NetconfMonitoringService cap) {
        super(netconfSessionIdForReporting);
        this.cap = cap;
    }

    protected String getOperationName() {
        return GET_SCHEMA;
    }

    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring";
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement xml) throws DocumentedException {
        String schema;
        GetSchemaEntry entry = new GetSchemaEntry(xml);
        try {
            schema = this.cap.getSchemaForCapability(entry.identifier, entry.version);
        }
        catch (IllegalStateException e) {
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(DocumentedException.ErrorTag.OPERATION_FAILED.toString(), e.getMessage());
            LOG.warn("Rpc error: {}", (Object)DocumentedException.ErrorTag.OPERATION_FAILED, (Object)e);
            throw new DocumentedException(e.getMessage(), (Exception)e, DocumentedException.ErrorType.APPLICATION, DocumentedException.ErrorTag.OPERATION_FAILED, DocumentedException.ErrorSeverity.ERROR, errorInfo);
        }
        Element getSchemaResult = XmlUtil.createTextElement((Document)document, (String)"data", (String)schema, Optional.of("urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring"));
        LOG.trace("{} operation successful", (Object)GET_SCHEMA);
        return getSchemaResult;
    }

    private static final class GetSchemaEntry {
        private final String identifier;
        private final Optional<String> version;

        GetSchemaEntry(XmlElement getSchemaElement) throws DocumentedException {
            XmlElement identifierElement;
            getSchemaElement.checkName(GetSchema.GET_SCHEMA);
            getSchemaElement.checkNamespace("urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring");
            try {
                identifierElement = getSchemaElement.getOnlyChildElementWithSameNamespace(GetSchema.IDENTIFIER);
            }
            catch (DocumentedException e) {
                LOG.trace("Can't get identifier element as only child element with same namespace due to ", (Throwable)e);
                throw DocumentedException.wrap((Exception)((Object)e));
            }
            this.identifier = identifierElement.getTextContent();
            Optional versionElement = getSchemaElement.getOnlyChildElementWithSameNamespaceOptionally(GetSchema.VERSION);
            this.version = versionElement.isPresent() ? Optional.of(((XmlElement)versionElement.get()).getTextContent()) : Optional.empty();
        }
    }
}

