/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.io.Serializable;
import java.util.Map;
import org.apache.karaf.scheduler.Job;
import org.apache.karaf.scheduler.JobContext;
import org.apache.karaf.scheduler.core.InternalScheduleOptions;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;

public class QuartzJobExecutor
implements org.quartz.Job {
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        Object job = data.get("QuartzJobScheduler.Object");
        Logger logger = (Logger)data.get("QuartzJobScheduler.Logger");
        try {
            logger.debug("Executing job {} with name {}", job, data.get("QuartzJobScheduler.JobName"));
            if (job instanceof Job) {
                InternalScheduleOptions options = (InternalScheduleOptions)data.get("QuartzJobScheduler.Options");
                String name = (String)data.get("QuartzJobScheduler.JobName");
                JobContextImpl jobCtx = new JobContextImpl(name, options.configuration);
                ((Job)job).execute(jobCtx);
            } else if (job instanceof Runnable) {
                ((Runnable)job).run();
            } else {
                logger.error("Scheduled job {} is neither a job nor a runnable.", job);
            }
        }
        catch (Throwable t) {
            logger.error("Exception during job execution of " + job + " : " + t.getMessage(), t);
        }
    }

    public static final class JobContextImpl
    implements JobContext {
        protected final Map<String, Serializable> configuration;
        protected final String name;

        public JobContextImpl(String name, Map<String, Serializable> config) {
            this.name = name;
            this.configuration = config;
        }

        @Override
        public Map<String, Serializable> getConfiguration() {
            return this.configuration;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

