/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.karaf.scheduler.ScheduleOptions;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class InternalScheduleOptions
implements ScheduleOptions {
    public String name;
    public boolean canRunConcurrently = false;
    public Map<String, Serializable> configuration;
    public final String schedule;
    public final TriggerBuilder<? extends Trigger> trigger;
    public final IllegalArgumentException argumentException;

    public InternalScheduleOptions(Date date) {
        if (date == null) {
            this.trigger = null;
            this.argumentException = new IllegalArgumentException("Date can't be null");
        } else {
            this.trigger = TriggerBuilder.newTrigger().startAt(date);
            this.argumentException = null;
        }
        this.schedule = "at(" + this.formatDate(date) + ")";
    }

    public InternalScheduleOptions(Date date, int times, long period) {
        TriggerBuilder<SimpleTrigger> trigger = null;
        IllegalArgumentException argumentException = null;
        try {
            if (date == null) {
                throw new IllegalArgumentException("Date can't be null");
            }
            if (times < 2 && times != -1) {
                throw new IllegalArgumentException("Times argument must be higher than 1 or -1");
            }
            if (period < 1L) {
                throw new IllegalArgumentException("Period argument must be higher than 0");
            }
            SimpleScheduleBuilder sb = times == -1 ? SimpleScheduleBuilder.simpleSchedule().repeatForever() : SimpleScheduleBuilder.simpleSchedule().withRepeatCount(times - 1);
            trigger = TriggerBuilder.newTrigger().startAt(date).withSchedule(sb.withIntervalInMilliseconds(period * 1000L));
        }
        catch (IllegalArgumentException e) {
            argumentException = e;
        }
        this.trigger = trigger;
        this.argumentException = argumentException;
        this.schedule = "at(" + this.formatDate(date) + ", " + times + ", " + period + ")";
    }

    public InternalScheduleOptions(String expression) {
        TriggerBuilder<CronTrigger> trigger = null;
        IllegalArgumentException argumentException = null;
        try {
            if (expression == null) {
                throw new IllegalArgumentException("Expression can't be null");
            }
            if (!CronExpression.isValidExpression(expression)) {
                throw new IllegalArgumentException("Expression is invalid : " + expression);
            }
            trigger = TriggerBuilder.newTrigger().withSchedule(CronScheduleBuilder.cronSchedule(expression));
        }
        catch (IllegalArgumentException e) {
            argumentException = e;
        }
        this.trigger = trigger;
        this.argumentException = argumentException;
        this.schedule = "cron(" + expression + ")";
    }

    @Override
    public ScheduleOptions config(Map<String, Serializable> config) {
        this.configuration = config;
        return this;
    }

    @Override
    public ScheduleOptions name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ScheduleOptions canRunConcurrently(boolean flag) {
        this.canRunConcurrently = flag;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean canRunConcurrently() {
        return this.canRunConcurrently;
    }

    @Override
    public String schedule() {
        return this.schedule;
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "null";
        }
        Calendar c = GregorianCalendar.getInstance();
        c.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)c);
    }
}

