/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.command;

import java.util.Map;
import org.apache.karaf.scheduler.ScheduleOptions;
import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="scheduler", name="list", description="List scheduled jobs")
@Service
public class List
implements Action {
    @Reference
    Scheduler scheduler;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Schedule");
        Map<Object, ScheduleOptions> jobs = this.scheduler.getJobs();
        for (Map.Entry<Object, ScheduleOptions> entry : jobs.entrySet()) {
            table.addRow().addContent(new Object[]{entry.getValue().name(), entry.getValue().schedule()});
        }
        table.print(System.out);
        return null;
    }
}

