/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.matches.ace.type.AceEth;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclEthHeaderFields;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AceEthBuilder
implements Builder<AceEth> {
    private MacAddress _destinationMacAddress;
    private MacAddress _destinationMacAddressMask;
    private MacAddress _sourceMacAddress;
    private MacAddress _sourceMacAddressMask;
    Map<Class<? extends Augmentation<AceEth>>, Augmentation<AceEth>> augmentation = Collections.emptyMap();

    public AceEthBuilder() {
    }

    public AceEthBuilder(AclEthHeaderFields arg) {
        this._destinationMacAddress = arg.getDestinationMacAddress();
        this._destinationMacAddressMask = arg.getDestinationMacAddressMask();
        this._sourceMacAddress = arg.getSourceMacAddress();
        this._sourceMacAddressMask = arg.getSourceMacAddressMask();
    }

    public AceEthBuilder(AceEth base) {
        Map aug;
        this._destinationMacAddress = base.getDestinationMacAddress();
        this._destinationMacAddressMask = base.getDestinationMacAddressMask();
        this._sourceMacAddress = base.getSourceMacAddress();
        this._sourceMacAddressMask = base.getSourceMacAddressMask();
        if (base instanceof AceEthImpl) {
            AceEthImpl impl = (AceEthImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AceEth>>, Augmentation<AceEth>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceEth>>, Augmentation<AceEth>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AclEthHeaderFields) {
            this._destinationMacAddress = ((AclEthHeaderFields)arg).getDestinationMacAddress();
            this._destinationMacAddressMask = ((AclEthHeaderFields)arg).getDestinationMacAddressMask();
            this._sourceMacAddress = ((AclEthHeaderFields)arg).getSourceMacAddress();
            this._sourceMacAddressMask = ((AclEthHeaderFields)arg).getSourceMacAddressMask();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218.AclEthHeaderFields]");
    }

    public MacAddress getDestinationMacAddress() {
        return this._destinationMacAddress;
    }

    public MacAddress getDestinationMacAddressMask() {
        return this._destinationMacAddressMask;
    }

    public MacAddress getSourceMacAddress() {
        return this._sourceMacAddress;
    }

    public MacAddress getSourceMacAddressMask() {
        return this._sourceMacAddressMask;
    }

    public <E$$ extends Augmentation<AceEth>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AceEthBuilder setDestinationMacAddress(MacAddress value) {
        this._destinationMacAddress = value;
        return this;
    }

    public AceEthBuilder setDestinationMacAddressMask(MacAddress value) {
        this._destinationMacAddressMask = value;
        return this;
    }

    public AceEthBuilder setSourceMacAddress(MacAddress value) {
        this._sourceMacAddress = value;
        return this;
    }

    public AceEthBuilder setSourceMacAddressMask(MacAddress value) {
        this._sourceMacAddressMask = value;
        return this;
    }

    public AceEthBuilder addAugmentation(Class<? extends Augmentation<AceEth>> augmentationType, Augmentation<AceEth> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AceEth>>, Augmentation<AceEth>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AceEthBuilder removeAugmentation(Class<? extends Augmentation<AceEth>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AceEth build() {
        return new AceEthImpl(this);
    }

    private static final class AceEthImpl
    implements AceEth {
        private final MacAddress _destinationMacAddress;
        private final MacAddress _destinationMacAddressMask;
        private final MacAddress _sourceMacAddress;
        private final MacAddress _sourceMacAddressMask;
        private Map<Class<? extends Augmentation<AceEth>>, Augmentation<AceEth>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AceEthImpl(AceEthBuilder base) {
            this._destinationMacAddress = base.getDestinationMacAddress();
            this._destinationMacAddressMask = base.getDestinationMacAddressMask();
            this._sourceMacAddress = base.getSourceMacAddress();
            this._sourceMacAddressMask = base.getSourceMacAddressMask();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<AceEth> getImplementedInterface() {
            return AceEth.class;
        }

        public MacAddress getDestinationMacAddress() {
            return this._destinationMacAddress;
        }

        public MacAddress getDestinationMacAddressMask() {
            return this._destinationMacAddressMask;
        }

        public MacAddress getSourceMacAddress() {
            return this._sourceMacAddress;
        }

        public MacAddress getSourceMacAddressMask() {
            return this._sourceMacAddressMask;
        }

        public <E$$ extends Augmentation<AceEth>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationMacAddress);
            result = 31 * result + Objects.hashCode(this._destinationMacAddressMask);
            result = 31 * result + Objects.hashCode(this._sourceMacAddress);
            result = 31 * result + Objects.hashCode(this._sourceMacAddressMask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AceEth.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AceEth other = (AceEth)obj;
            if (!Objects.equals(this._destinationMacAddress, other.getDestinationMacAddress())) {
                return false;
            }
            if (!Objects.equals(this._destinationMacAddressMask, other.getDestinationMacAddressMask())) {
                return false;
            }
            if (!Objects.equals(this._sourceMacAddress, other.getSourceMacAddress())) {
                return false;
            }
            if (!Objects.equals(this._sourceMacAddressMask, other.getSourceMacAddressMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AceEthImpl otherImpl = (AceEthImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AceEth>>, Augmentation<AceEth>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"AceEth");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destinationMacAddress", (Object)this._destinationMacAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destinationMacAddressMask", (Object)this._destinationMacAddressMask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceMacAddress", (Object)this._sourceMacAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_sourceMacAddressMask", (Object)this._sourceMacAddressMask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

