/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.console.api.NetconfCommands;
import org.opendaylight.netconf.console.utils.NetconfConsoleUtils;
import org.opendaylight.netconf.console.utils.NetconfIidFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.NetconfNodeConnectionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.connection.status.available.capabilities.AvailableCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPassword;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.node.topology.rev150114.netconf.node.credentials.credentials.LoginPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfCommandsImpl
implements NetconfCommands {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfCommandsImpl.class);
    private final DataBroker dataBroker;

    public NetconfCommandsImpl(DataBroker db) {
        LOG.debug("NetconfConsoleProviderImpl initialized");
        this.dataBroker = db;
    }

    @Override
    public Map<String, Map<String, String>> listDevices() {
        Topology topology = NetconfConsoleUtils.read(LogicalDatastoreType.OPERATIONAL, NetconfIidFactory.NETCONF_TOPOLOGY_IID, this.dataBroker);
        if (topology == null) {
            return new HashMap<String, Map<String, String>>();
        }
        HashMap<String, Map<String, String>> netconfNodes = new HashMap<String, Map<String, String>>();
        for (Node node : topology.getNode()) {
            NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("NETCONF ID", node.getNodeId().getValue());
            attributes.put("NETCONF IP", netconfNode.getHost().getIpAddress().getIpv4Address().getValue());
            attributes.put("NETCONF Port", netconfNode.getPort().getValue().toString());
            attributes.put("Status", netconfNode.getConnectionStatus().name().toLowerCase(Locale.ROOT));
            netconfNodes.put(node.getNodeId().getValue(), attributes);
        }
        return netconfNodes;
    }

    @Override
    public Map<String, Map<String, List<String>>> showDevice(String deviceIp, String devicePort) {
        HashMap<String, Map<String, List<String>>> device = new HashMap<String, Map<String, List<String>>>();
        List<Object> nodeList = new ArrayList<Node>();
        if (devicePort != null) {
            nodeList.add(NetconfConsoleUtils.getNetconfNodeFromIpAndPort(deviceIp, devicePort, this.dataBroker));
        } else {
            nodeList = NetconfConsoleUtils.getNetconfNodeFromId(deviceIp, this.dataBroker);
        }
        if (nodeList != null) {
            for (Node node : nodeList) {
                if (node == null) continue;
                NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("NETCONF ID", ImmutableList.of((Object)node.getNodeId().getValue()));
                attributes.put("NETCONF IP", ImmutableList.of((Object)netconfNode.getHost().getIpAddress().getIpv4Address().getValue()));
                attributes.put("NETCONF Port", ImmutableList.of((Object)netconfNode.getPort().getValue().toString()));
                attributes.put("Status", ImmutableList.of((Object)netconfNode.getConnectionStatus().name()));
                if (netconfNode.getConnectionStatus().equals((Object)NetconfNodeConnectionStatus.ConnectionStatus.Connected)) {
                    attributes.put("Available Capabilities", netconfNode.getAvailableCapabilities().getAvailableCapability().stream().map(AvailableCapability::getCapability).collect(Collectors.toList()));
                } else {
                    attributes.put("Available Capabilities", Collections.singletonList(""));
                }
                device.put(node.getNodeId().getValue(), attributes);
            }
        }
        return device;
    }

    @Override
    public Map<String, Map<String, List<String>>> showDevice(String deviceId) {
        HashMap<String, Map<String, List<String>>> device = new HashMap<String, Map<String, List<String>>>();
        List<Node> nodeList = NetconfConsoleUtils.getNetconfNodeFromId(deviceId, this.dataBroker);
        if (nodeList != null && nodeList.size() > 0) {
            for (Node node : nodeList) {
                NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("NETCONF ID", ImmutableList.of((Object)node.getNodeId().getValue()));
                attributes.put("NETCONF IP", ImmutableList.of((Object)netconfNode.getHost().getIpAddress().getIpv4Address().getValue()));
                attributes.put("NETCONF Port", ImmutableList.of((Object)netconfNode.getPort().getValue().toString()));
                attributes.put("Status", ImmutableList.of((Object)netconfNode.getConnectionStatus().name()));
                if (netconfNode.getConnectionStatus().equals((Object)NetconfNodeConnectionStatus.ConnectionStatus.Connected)) {
                    attributes.put("Available Capabilities", netconfNode.getAvailableCapabilities().getAvailableCapability().stream().map(AvailableCapability::getCapability).collect(Collectors.toList()));
                } else {
                    attributes.put("Available Capabilities", Collections.singletonList(""));
                }
                device.put(node.getNodeId().getValue(), attributes);
            }
        }
        return device;
    }

    @Override
    public void connectDevice(final NetconfNode netconfNode, String netconfNodeId) {
        NodeId nodeId = !Strings.isNullOrEmpty((String)netconfNodeId) ? new NodeId(netconfNodeId) : new NodeId(UUID.randomUUID().toString().replace("-", ""));
        Node node = new NodeBuilder().withKey(new NodeKey(nodeId)).setNodeId(nodeId).addAugmentation(NetconfNode.class, (Augmentation)netconfNode).build();
        WriteTransaction transaction = this.dataBroker.newWriteOnlyTransaction();
        transaction.put(LogicalDatastoreType.CONFIGURATION, NetconfIidFactory.netconfNodeIid(nodeId.getValue()), (DataObject)node);
        transaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("NetconfNode={} created successfully", (Object)netconfNode);
            }

            public void onFailure(Throwable throwable) {
                LOG.error("Failed to created NetconfNode={}", (Object)netconfNode, (Object)throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public boolean disconnectDevice(String netconfNodeId) {
        WriteTransaction transaction = this.dataBroker.newWriteOnlyTransaction();
        InstanceIdentifier<Node> iid = NetconfIidFactory.netconfNodeIid(netconfNodeId);
        transaction.delete(LogicalDatastoreType.CONFIGURATION, iid);
        try {
            LOG.debug("Deleting netconf node: {}", (Object)netconfNodeId);
            transaction.commit().get();
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to remove node with Iid {}", iid, (Object)e);
            return false;
        }
    }

    @Override
    public boolean disconnectDevice(String deviceIp, String devicePort) {
        String netconfNodeId = NetconfConsoleUtils.getNetconfNodeFromIpAndPort(deviceIp, devicePort, this.dataBroker).getNodeId().getValue();
        return this.disconnectDevice(netconfNodeId);
    }

    @Override
    public String updateDevice(String netconfNodeId, String username, String password, Map<String, String> updated) {
        Node node = NetconfConsoleUtils.read(LogicalDatastoreType.OPERATIONAL, NetconfIidFactory.netconfNodeIid(netconfNodeId), this.dataBroker);
        if (node != null && node.augmentation(NetconfNode.class) != null) {
            final NetconfNode netconfNode = (NetconfNode)node.augmentation(NetconfNode.class);
            String deviceIp = Strings.isNullOrEmpty((String)updated.get("NETCONF IP")) ? netconfNode.getHost().getIpAddress().getIpv4Address().getValue() : updated.get("NETCONF IP");
            String devicePort = Strings.isNullOrEmpty((String)updated.get("NETCONF Port")) ? netconfNode.getPort().getValue().toString() : updated.get("NETCONF Port");
            Boolean tcpOnly = updated.get("tcp-only").equals("true");
            Boolean isSchemaless = updated.get("schemaless").equals("true");
            String newUsername = Strings.isNullOrEmpty((String)updated.get("username")) ? updated.get("username") : username;
            String newPassword = Strings.isNullOrEmpty((String)updated.get("password")) ? updated.get("password") : password;
            LoginPassword credentials = new LoginPasswordBuilder().setPassword(newPassword).setUsername(newUsername).build();
            NetconfNode updatedNetconfNode = new NetconfNodeBuilder().setHost(new Host(new IpAddress(new Ipv4Address(deviceIp)))).setPort(new PortNumber(Integer.decode(devicePort))).setTcpOnly(tcpOnly).setSchemaless(isSchemaless).setCredentials((Credentials)credentials).build();
            Node updatedNode = new NodeBuilder().withKey(node.key()).setNodeId(node.getNodeId()).addAugmentation(NetconfNode.class, (Augmentation)updatedNetconfNode).build();
            WriteTransaction transaction = this.dataBroker.newWriteOnlyTransaction();
            transaction.put(LogicalDatastoreType.CONFIGURATION, NetconfIidFactory.netconfNodeIid(updatedNode.getNodeId().getValue()), (DataObject)updatedNode);
            transaction.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    LOG.debug("NetconfNode={} updated successfully", (Object)netconfNode);
                }

                public void onFailure(Throwable throwable) {
                    LOG.error("Failed to updated NetconfNode={}", (Object)netconfNode, (Object)throwable);
                }
            }, MoreExecutors.directExecutor());
            return "NETCONF node: " + netconfNodeId + " updated successfully.";
        }
        return "NETCONF node: " + netconfNodeId + " does not exist to update";
    }
}

