/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.commands;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opendaylight.netconf.console.api.NetconfCommands;

@Service
@Command(name="update-device", scope="netconf", description="Update netconf device attributes.")
public class NetconfUpdateDeviceCommand
implements Action {
    @Reference
    private NetconfCommands service;
    @Option(name="-id", aliases={"--nodeId"}, description="NETCONF node ID of the netconf device", required=true, multiValued=false)
    private String deviceId;
    @Option(name="-U", aliases={"--username"}, description="Username for NETCONF connection", required=true, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="Password for NETCONF connection", required=true, multiValued=false)
    private String password;
    @Option(name="-ni", aliases={"--new-ipaddress"}, description="New IP address of NETCONF device", required=false, multiValued=false)
    private String newIp;
    @Option(name="-np", aliases={"--new-port"}, description="New Port of NETCONF device", required=false, multiValued=false)
    private String newPort;
    @Option(name="-nU", aliases={"--new-username"}, description="New Username for NETCONF connection", required=false, multiValued=false)
    private String newUsername;
    @Option(name="-nP", aliases={"--new-password"}, description="New Password for NETCONF connection", required=false, multiValued=false)
    private String newPassword;
    @Option(name="-t", aliases={"--tcp-only"}, description="Type of connection, true for tcp only", required=false, multiValued=false)
    private String newConnectionType = "false";
    @Option(name="-sl", aliases={"--schemaless"}, description="Schemaless surpport, true for schemaless", required=false, multiValued=false)
    private String newSchemaless = "false";

    public NetconfUpdateDeviceCommand() {
    }

    @VisibleForTesting
    NetconfUpdateDeviceCommand(NetconfCommands service, String newIp) {
        this.service = service;
        this.newIp = newIp;
    }

    public Object execute() {
        HashMap<String, String> updated = new HashMap<String, String>();
        updated.put("NETCONF IP", this.newIp);
        updated.put("NETCONF Port", this.newPort);
        updated.put("username", this.newUsername);
        updated.put("password", this.newPassword);
        updated.put("tcp-only", this.newConnectionType);
        updated.put("schemaless", this.newSchemaless);
        updated.values().remove(null);
        if (updated.isEmpty()) {
            return "Nothing to update.";
        }
        return this.service.updateDevice(this.deviceId, this.username, this.password, updated);
    }
}

