/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opendaylight.netconf.console.api.NetconfCommands;
import org.opendaylight.netconf.console.commands.NetconfCommandUtils;

@Service
@Command(name="show-device", scope="netconf", description="Shows netconf device attributes.")
public class NetconfShowDeviceCommand
implements Action {
    @Reference
    private NetconfCommands service;
    @Option(name="-id", aliases={"--identifier"}, description="Node Identifier of the netconf device", required=false, multiValued=false)
    private String deviceId;
    @Option(name="-i", aliases={"--ipaddress"}, description="IP address of the netconf device", required=false, multiValued=false)
    private String deviceIp;
    @Option(name="-p", aliases={"--port"}, description="Port of the netconf device", required=false, multiValued=false)
    private String devicePort;

    public NetconfShowDeviceCommand() {
    }

    @VisibleForTesting
    NetconfShowDeviceCommand(NetconfCommands service) {
        this.service = service;
    }

    @VisibleForTesting
    NetconfShowDeviceCommand(NetconfCommands service, String deviceId, String deviceIp, String devicePort) {
        this.service = service;
        this.deviceId = deviceId;
        this.deviceIp = deviceIp;
        this.devicePort = devicePort;
    }

    public Object execute() {
        if ((Strings.isNullOrEmpty((String)this.deviceIp) || Strings.isNullOrEmpty((String)this.devicePort)) && Strings.isNullOrEmpty((String)this.deviceId)) {
            return "You must provide either the device Ip and the device Port or the device Id";
        }
        Map<String, Map<String, List<String>>> devices = null;
        if (!Strings.isNullOrEmpty((String)this.deviceId)) {
            devices = this.service.showDevice(this.deviceId);
            NetconfShowDeviceCommand.printDeviceData(devices);
            return null;
        }
        if (!NetconfCommandUtils.isIpValid(this.deviceIp) || this.devicePort != null && !NetconfCommandUtils.isPortValid(this.devicePort)) {
            return "Invalid IP:" + this.deviceIp + " or Port:" + this.devicePort + "Please enter a valid entry to proceed.";
        }
        devices = this.service.showDevice(this.deviceIp, this.devicePort);
        NetconfShowDeviceCommand.printDeviceData(devices);
        return null;
    }

    private static void printDeviceData(@Nonnull Map<String, Map<String, List<String>>> devices) {
        ShellTable table = new ShellTable();
        table.column("NETCONF ID").alignLeft();
        table.column("NETCONF IP").alignLeft();
        table.column("NETCONF Port").alignLeft();
        table.column("Status").alignLeft();
        table.column("Available Capabilities").alignLeft();
        for (Map.Entry<String, Map<String, List<String>>> entry : devices.entrySet()) {
            String nodeId = entry.getKey();
            Map<String, List<String>> device = entry.getValue();
            table.addRow().addContent(new Object[]{nodeId, device.get("NETCONF IP").get(0), device.get("NETCONF Port").get(0), device.get("Status").get(0), device.get("Available Capabilities").get(0)});
            NetconfShowDeviceCommand.formatCapabilities(device, table, "Available Capabilities");
        }
        table.print(System.out);
    }

    private static void formatCapabilities(Map<String, List<String>> device, ShellTable table, String capabilityName) {
        for (String availableCapability : device.get(capabilityName)) {
            if (Strings.isNullOrEmpty((String)availableCapability) || NetconfShowDeviceCommand.isFirstAvailableCapability(device, capabilityName, availableCapability)) continue;
            table.addRow().addContent(new Object[]{"", "", "", "", availableCapability});
        }
    }

    private static boolean isFirstAvailableCapability(Map<String, List<String>> device, String capabilityName, String availableCapability) {
        return device.get(capabilityName).indexOf(availableCapability) == 0;
    }
}

