/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.commands;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opendaylight.netconf.console.api.NetconfCommands;

@Service
@Command(name="list-devices", scope="netconf", description="List all netconf devices in the topology.")
public class NetconfListDevicesCommand
implements Action {
    @Reference
    private NetconfCommands service;

    public NetconfListDevicesCommand() {
    }

    @VisibleForTesting
    NetconfListDevicesCommand(NetconfCommands service) {
        this.service = service;
    }

    public Object execute() {
        Map<String, Map<String, String>> allDevices = this.service.listDevices();
        NetconfListDevicesCommand.printDevicesList(allDevices);
        return null;
    }

    private static void printDevicesList(@Nonnull Map<String, Map<String, String>> allDevices) {
        ShellTable table = new ShellTable();
        table.column("NETCONF ID").alignLeft();
        table.column("NETCONF IP").alignLeft();
        table.column("NETCONF Port").alignLeft();
        table.column("Status").alignLeft();
        for (Map<String, String> attributes : allDevices.values()) {
            table.addRow().addContent(new Object[]{attributes.get("NETCONF ID"), attributes.get("NETCONF IP"), attributes.get("NETCONF Port"), attributes.get("Status")});
        }
        table.print(System.out);
    }
}

