/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.console.commands;

import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetconfCommandUtils {
    private static final Pattern IP_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    private NetconfCommandUtils() {
    }

    public static boolean isPortValid(String devicePort) {
        Integer port;
        if (Strings.isNullOrEmpty((String)devicePort)) {
            return false;
        }
        try {
            port = Integer.parseInt(devicePort);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return port >= 0 && port <= 65535;
    }

    public static boolean isIpValid(String deviceIp) {
        if (Strings.isNullOrEmpty((String)deviceIp)) {
            return false;
        }
        Matcher matcher = IP_PATTERN.matcher(deviceIp);
        return matcher.matches();
    }
}

