/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

@Beta
public class OperationAsContainer
extends ForwardingObject
implements ContainerSchemaNode,
OperationDefinition {
    private final OperationDefinition delegate;

    OperationAsContainer(OperationDefinition parentNode) {
        this.delegate = Objects.requireNonNull(parentNode);
    }

    public static OperationAsContainer of(OperationDefinition delegate) {
        return new OperationAsContainer(delegate);
    }

    protected final OperationDefinition delegate() {
        return this.delegate;
    }

    public final Optional<String> getDescription() {
        return this.delegate.getDescription();
    }

    public final Optional<String> getReference() {
        return this.delegate.getReference();
    }

    public final Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.delegate.getTypeDefinitions();
    }

    public final Set<GroupingDefinition> getGroupings() {
        return this.delegate.getGroupings();
    }

    public final Status getStatus() {
        return this.delegate.getStatus();
    }

    public final ContainerSchemaNode getInput() {
        return this.delegate.getInput();
    }

    public final ContainerSchemaNode getOutput() {
        return this.delegate.getOutput();
    }

    public final QName getQName() {
        return this.delegate.getQName();
    }

    public final SchemaPath getPath() {
        return this.delegate.getPath();
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        switch (name.getLocalName()) {
            case "input": {
                return Optional.of(this.delegate.getInput());
            }
            case "output": {
                return Optional.of(this.delegate.getOutput());
            }
        }
        return Optional.empty();
    }

    public Set<UsesNode> getUses() {
        return ImmutableSet.of();
    }

    public final Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return ImmutableSet.of();
    }

    public final boolean isPresenceContainer() {
        return false;
    }

    public final Collection<DataSchemaNode> getChildNodes() {
        ArrayList<DataSchemaNode> ret = new ArrayList<DataSchemaNode>();
        ContainerSchemaNode input = this.getInput();
        ContainerSchemaNode output = this.getOutput();
        if (input != null) {
            ret.add((DataSchemaNode)input);
        }
        if (output != null) {
            ret.add((DataSchemaNode)output);
        }
        return ret;
    }

    @Deprecated
    public final boolean isAugmenting() {
        return false;
    }

    @Deprecated
    public final boolean isAddedByUses() {
        return false;
    }

    public final boolean isConfiguration() {
        return false;
    }

    public final Set<ActionDefinition> getActions() {
        return ImmutableSet.of();
    }

    public final Set<NotificationDefinition> getNotifications() {
        return ImmutableSet.of();
    }

    public final Collection<MustDefinition> getMustConstraints() {
        return ImmutableSet.of();
    }

    public final Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.empty();
    }
}

