/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.util.ImmutableMapTemplate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamAttributeWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class ListEntryNodeDataWithSchema
extends CompositeNodeDataWithSchema {
    private final ImmutableMapTemplate<QName> predicateTemplate;
    private final Map<QName, SimpleNodeDataWithSchema> keyValues;

    public ListEntryNodeDataWithSchema(DataSchemaNode schema) {
        super(schema);
        List keyDef = ((ListSchemaNode)this.getSchema()).getKeyDefinition();
        if (keyDef.isEmpty()) {
            this.predicateTemplate = null;
            this.keyValues = null;
        } else {
            this.predicateTemplate = ImmutableMapTemplate.ordered((Collection)keyDef);
            this.keyValues = new HashMap<QName, SimpleNodeDataWithSchema>();
        }
    }

    @Override
    public void addChild(AbstractNodeDataWithSchema newChild) {
        DataSchemaNode childSchema;
        if (this.predicateTemplate != null && (childSchema = newChild.getSchema()) instanceof LeafSchemaNode) {
            this.populateKeyValue(childSchema.getQName(), newChild);
        }
        super.addChild(newChild);
    }

    private void populateKeyValue(QName childName, AbstractNodeDataWithSchema child) {
        if (this.predicateTemplate.keySet().contains(childName)) {
            Verify.verify((boolean)(child instanceof SimpleNodeDataWithSchema));
            this.keyValues.put(childName, (SimpleNodeDataWithSchema)child);
        }
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer) throws IOException {
        writer.nextDataSchemaNode(this.getSchema());
        if (this.predicateTemplate != null) {
            this.writeKeyedListItem(writer);
        } else {
            writer.startUnkeyedListItem(this.provideNodeIdentifier(), this.childSizeHint());
        }
        super.write(writer);
        writer.endNode();
    }

    private void writeKeyedListItem(NormalizedNodeStreamWriter writer) throws IOException {
        Set keySet = this.predicateTemplate.keySet();
        Preconditions.checkState((keySet.size() == this.keyValues.size() ? 1 : 0) != 0, (String)"Map entry corresponding to %s is missing some of required keys %s", (Object)this.getSchema().getQName(), (Object)keySet);
        YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = new YangInstanceIdentifier.NodeIdentifierWithPredicates(this.getSchema().getQName(), (Map)this.predicateTemplate.instantiateTransformed(this.keyValues, (key, node) -> node.getValue()));
        if (writer instanceof NormalizedNodeStreamAttributeWriter && this.getAttributes() != null) {
            ((NormalizedNodeStreamAttributeWriter)writer).startMapEntryNode(identifier, this.childSizeHint(), this.getAttributes());
        } else {
            writer.startMapEntryNode(identifier, this.childSizeHint());
        }
    }
}

