/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class LeafsetEntryInterner {
    private static final Logger LOG = LoggerFactory.getLogger(LeafsetEntryInterner.class);
    private static final LeafsetEntryInterner INSTANCE = new LeafsetEntryInterner();
    private static final Interner<Object> INTERNER = Interners.newWeakInterner();

    private LeafsetEntryInterner() {
    }

    public <T extends LeafSetEntryNode<?>> @NonNull T intern(@NonNull T sample) {
        if (!sample.getAttributes().isEmpty()) {
            return sample;
        }
        LeafSetEntryNode ret = (LeafSetEntryNode)INTERNER.intern(sample);
        LOG.trace("Interned object {} to {}", sample, (Object)ret);
        return (T)ret;
    }

    public static @Nullable LeafsetEntryInterner forSchema(@Nullable LeafListSchemaNode schema) {
        TypeDefinition type;
        if (schema != null && ((type = schema.getType()) instanceof BooleanTypeDefinition || type instanceof EnumTypeDefinition || type instanceof IdentityrefTypeDefinition)) {
            return INSTANCE;
        }
        return null;
    }
}

