/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AnyXmlContextNode;
import org.opendaylight.yangtools.yang.data.util.AugmentationContextNode;
import org.opendaylight.yangtools.yang.data.util.ChoiceNodeContextNode;
import org.opendaylight.yangtools.yang.data.util.ContainerContextNode;
import org.opendaylight.yangtools.yang.data.util.LeafContextNode;
import org.opendaylight.yangtools.yang.data.util.OrderedLeafListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.OrderedMapMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnkeyedListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnorderedLeafListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnorderedMapMixinContextNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

public abstract class DataSchemaContextNode<T extends YangInstanceIdentifier.PathArgument>
implements Identifiable<T> {
    private final DataSchemaNode dataSchemaNode;
    private final T identifier;

    protected DataSchemaContextNode(T identifier, SchemaNode schema) {
        this.identifier = identifier;
        this.dataSchemaNode = schema instanceof DataSchemaNode ? (DataSchemaNode)schema : null;
    }

    public T getIdentifier() {
        return this.identifier;
    }

    public boolean isMixin() {
        return false;
    }

    public boolean isKeyedEntry() {
        return false;
    }

    public abstract boolean isLeaf();

    protected Set<QName> getQNameIdentifiers() {
        return ImmutableSet.of((Object)this.identifier.getNodeType());
    }

    public abstract @Nullable DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument var1);

    public abstract @Nullable DataSchemaContextNode<?> getChild(QName var1);

    public @Nullable DataSchemaNode getDataSchemaNode() {
        return this.dataSchemaNode;
    }

    public final @NonNull Optional<@NonNull DataSchemaContextNode<?>> findChild(@NonNull YangInstanceIdentifier path) {
        DataSchemaContextNode<?> currentOp = this;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            if ((currentOp = currentOp.getChild(arg)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(currentOp);
    }

    static DataSchemaNode findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.getDataChildByName(child);
        return potential == null ? DataSchemaContextNode.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child) : potential;
    }

    static DataSchemaContextNode<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        DataSchemaNode result = DataSchemaContextNode.findChildSchemaNode(schema, child);
        if (result != null && schema instanceof DataSchemaNode && result.isAugmenting()) {
            return DataSchemaContextNode.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return DataSchemaContextNode.fromDataSchemaNode(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases().values()) {
                if (DataSchemaContextNode.findChildSchemaNode((DataNodeContainer)caze, child) == null) continue;
                return choice;
            }
        }
        return null;
    }

    public static YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifierFrom(AugmentationSchemaNode schema) {
        return new YangInstanceIdentifier.AugmentationIdentifier(schema.getChildNodes().stream().map(SchemaNode::getQName).collect(Collectors.toSet()));
    }

    @Deprecated
    public static AugmentationSchemaNode augmentationProxy(AugmentationSchemaNode schema, DataNodeContainer parent) {
        return EffectiveAugmentationSchema.create((AugmentationSchemaNode)schema, (DataNodeContainer)parent);
    }

    static @Nullable DataSchemaContextNode<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        for (AugmentationSchemaNode aug : parentAug.getAvailableAugmentations()) {
            if (!aug.findDataChildByName(child.getQName()).isPresent()) continue;
            return new AugmentationContextNode(aug, parent);
        }
        return DataSchemaContextNode.fromDataSchemaNode(child);
    }

    public static @Nullable DataSchemaContextNode<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new ContainerContextNode((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return DataSchemaContextNode.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new LeafContextNode((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new ChoiceNodeContextNode((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return DataSchemaContextNode.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnyXmlSchemaNode) {
            return new AnyXmlContextNode((AnyXmlSchemaNode)potential);
        }
        return null;
    }

    private static DataSchemaContextNode<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixinContextNode(potential);
        }
        if (potential.isUserOrdered()) {
            return new OrderedMapMixinContextNode(potential);
        }
        return new UnorderedMapMixinContextNode(potential);
    }

    private static DataSchemaContextNode<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        if (potential.isUserOrdered()) {
            return new OrderedLeafListMixinContextNode(potential);
        }
        return new UnorderedLeafListMixinContextNode(potential);
    }

    public static DataSchemaContextNode<?> from(SchemaContext ctx) {
        return new ContainerContextNode((ContainerSchemaNode)ctx);
    }
}

