/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AbstractInteriorContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

class DataContainerContextNode<T extends YangInstanceIdentifier.PathArgument>
extends AbstractInteriorContextNode<T> {
    private final DataNodeContainer schema;
    private final Map<QName, DataSchemaContextNode<?>> byQName;
    private final Map<YangInstanceIdentifier.PathArgument, DataSchemaContextNode<?>> byArg;

    protected DataContainerContextNode(T identifier, DataNodeContainer schema, DataSchemaNode node) {
        super(identifier, node);
        this.schema = schema;
        this.byArg = new ConcurrentHashMap();
        this.byQName = new ConcurrentHashMap();
    }

    @Override
    public DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument child) {
        DataSchemaContextNode<?> potential = this.byArg.get(child);
        if (potential != null) {
            return potential;
        }
        potential = this.fromLocalSchema(child);
        return this.register(potential);
    }

    @Override
    public DataSchemaContextNode<?> getChild(QName child) {
        DataSchemaContextNode<?> potential = this.byQName.get(child);
        if (potential != null) {
            return potential;
        }
        potential = this.fromLocalSchemaAndQName(this.schema, child);
        return this.register(potential);
    }

    private DataSchemaContextNode<?> fromLocalSchema(YangInstanceIdentifier.PathArgument child) {
        if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return DataContainerContextNode.fromSchemaAndQNameChecked(this.schema, (QName)((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames().iterator().next());
        }
        return DataContainerContextNode.fromSchemaAndQNameChecked(this.schema, child.getNodeType());
    }

    protected DataSchemaContextNode<?> fromLocalSchemaAndQName(DataNodeContainer schema2, QName child) {
        return DataContainerContextNode.fromSchemaAndQNameChecked(schema2, child);
    }

    private DataSchemaContextNode<?> register(DataSchemaContextNode<?> potential) {
        if (potential != null) {
            this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getIdentifier(), potential);
            for (QName qname : potential.getQNameIdentifiers()) {
                this.byQName.put(qname, potential);
            }
        }
        return potential;
    }
}

