/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.Objects;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringUnionCodec
implements Codec<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStringUnionCodec.class);
    protected final DataSchemaNode schema;
    protected final UnionTypeDefinition typeDefinition;

    protected AbstractStringUnionCodec(DataSchemaNode schema, UnionTypeDefinition typeDefinition) {
        this.schema = Objects.requireNonNull(schema);
        this.typeDefinition = Objects.requireNonNull(typeDefinition);
    }

    protected abstract Codec<String, Object> codecFor(TypeDefinition<?> var1);

    public final String serialize(Object data) {
        for (TypeDefinition type : this.typeDefinition.getTypes()) {
            Codec<String, Object> codec = this.codecFor(type);
            if (codec == null) {
                LOG.debug("no codec found for {}", (Object)type);
                continue;
            }
            try {
                return (String)codec.serialize(data);
            }
            catch (Exception e) {
                LOG.debug("Data {} did not match for {}", new Object[]{data, type, e});
            }
        }
        throw new IllegalArgumentException("Invalid data \"" + data + "\" for union type.");
    }

    public Object deserialize(String stringRepresentation) {
        if (stringRepresentation == null) {
            return null;
        }
        String returnValue = null;
        for (TypeDefinition type : this.typeDefinition.getTypes()) {
            Codec<String, Object> codec = this.codecFor(type);
            if (codec == null) {
                returnValue = stringRepresentation;
                continue;
            }
            try {
                Object deserialized = codec.deserialize((Object)stringRepresentation);
                if (deserialized != null) {
                    return deserialized;
                }
                returnValue = stringRepresentation;
            }
            catch (Exception e) {
                LOG.debug("Value {} did not matched representation for {}", new Object[]{stringRepresentation, type, e});
            }
        }
        if (returnValue != null) {
            return returnValue;
        }
        throw new IllegalArgumentException("Invalid value \"" + stringRepresentation + "\" for union type.");
    }
}

