/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;

public final class Annotateds {
    private static final char SEPARATOR = ';';

    private Annotateds() {
    }

    public static <X> String createTypeId(AnnotatedType<X> annotatedType) {
        return Annotateds.createTypeId(annotatedType.getJavaClass(), annotatedType.getAnnotations(), annotatedType.getMethods(), annotatedType.getFields(), annotatedType.getConstructors());
    }

    public static <X> String createTypeId(Class<X> clazz, Collection<Annotation> annotations, Collection<AnnotatedMethod<? super X>> methods, Collection<AnnotatedField<? super X>> fields, Collection<AnnotatedConstructor<X>> constructors) {
        StringBuilder builder = new StringBuilder();
        builder.append(clazz.getName());
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        builder.append("{");
        ArrayList<AnnotatedField<? super X>> sortedFields = new ArrayList<AnnotatedField<? super X>>();
        sortedFields.addAll(fields);
        Collections.sort(sortedFields, AnnotatedFieldComparator.instance());
        for (AnnotatedField annotatedField : sortedFields) {
            if (annotatedField.getAnnotations().isEmpty()) continue;
            builder.append(Annotateds.createFieldId(annotatedField));
            builder.append(';');
        }
        ArrayList<AnnotatedMethod<? super X>> sortedMethods = new ArrayList<AnnotatedMethod<? super X>>();
        sortedMethods.addAll(methods);
        Collections.sort(sortedMethods, AnnotatedMethodComparator.instance());
        for (AnnotatedMethod annotatedMethod : sortedMethods) {
            if (annotatedMethod.getAnnotations().isEmpty() && !Annotateds.hasMethodParameters(annotatedMethod)) continue;
            builder.append(Annotateds.createCallableId(annotatedMethod));
            builder.append(';');
        }
        ArrayList<AnnotatedConstructor<X>> arrayList = new ArrayList<AnnotatedConstructor<X>>();
        arrayList.addAll(constructors);
        Collections.sort(arrayList, AnnotatedConstructorComparator.instance());
        for (AnnotatedConstructor annotatedConstructor : arrayList) {
            if (annotatedConstructor.getAnnotations().isEmpty() && !Annotateds.hasMethodParameters(annotatedConstructor)) continue;
            builder.append(Annotateds.createCallableId(annotatedConstructor));
            builder.append(';');
        }
        builder.append("}");
        return builder.toString();
    }

    public static <X> String createFieldId(AnnotatedField<X> field) {
        return Annotateds.createFieldId(field.getJavaMember(), field.getAnnotations());
    }

    public static <X> String createFieldId(Field field, Collection<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        builder.append(field.getDeclaringClass().getName());
        builder.append('.');
        builder.append(field.getName());
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        return builder.toString();
    }

    public static <X> String createCallableId(AnnotatedCallable<X> method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getJavaMember().getDeclaringClass().getName());
        builder.append('.');
        builder.append(method.getJavaMember().getName());
        builder.append(Annotateds.createAnnotationCollectionId(method.getAnnotations()));
        builder.append(Annotateds.createParameterListId(method.getParameters()));
        return builder.toString();
    }

    public static <X> String createMethodId(Method method, Set<Annotation> annotations, List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getName());
        builder.append('.');
        builder.append(method.getName());
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        builder.append(Annotateds.createParameterListId(parameters));
        return builder.toString();
    }

    public static <X> String createConstructorId(Constructor<X> constructor, Set<Annotation> annotations, List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(constructor.getDeclaringClass().getName());
        builder.append('.');
        builder.append(constructor.getName());
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        builder.append(Annotateds.createParameterListId(parameters));
        return builder.toString();
    }

    public static <X> String createParameterListId(List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            AnnotatedParameter<X> ap = parameters.get(i);
            builder.append(Annotateds.createParameterId(ap));
            if (i + 1 == parameters.size()) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    public static <X> String createParameterId(AnnotatedParameter<X> annotatedParameter) {
        return Annotateds.createParameterId(annotatedParameter.getBaseType(), annotatedParameter.getAnnotations());
    }

    public static <X> String createParameterId(Type type, Set<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        if (type instanceof Class) {
            Class c = (Class)type;
            builder.append(c.getName());
        } else {
            builder.append(type.toString());
        }
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        return builder.toString();
    }

    public static boolean compareAnnotatedField(AnnotatedField<?> f1, AnnotatedField<?> f2) {
        if (!f1.getJavaMember().equals(f2.getJavaMember())) {
            return false;
        }
        return Annotateds.compareAnnotated(f1, f2);
    }

    public static boolean compareAnnotatedCallable(AnnotatedCallable<?> m1, AnnotatedCallable<?> m2) {
        if (!m1.getJavaMember().equals(m2.getJavaMember())) {
            return false;
        }
        if (!Annotateds.compareAnnotated(m1, m2)) {
            return false;
        }
        return Annotateds.compareAnnotatedParameters(m1.getParameters(), m2.getParameters());
    }

    public static boolean compareAnnotatedTypes(AnnotatedType<?> t1, AnnotatedType<?> t2) {
        if (!t1.getJavaClass().equals(t2.getJavaClass())) {
            return false;
        }
        if (!Annotateds.compareAnnotated(t1, t2)) {
            return false;
        }
        if (t1.getFields().size() != t2.getFields().size()) {
            return false;
        }
        HashMap<Field, AnnotatedField> fields = new HashMap<Field, AnnotatedField>();
        for (Object f : t2.getFields()) {
            fields.put(f.getJavaMember(), (AnnotatedField)f);
        }
        for (Object f : t1.getFields()) {
            if (fields.containsKey(f.getJavaMember())) {
                if (Annotateds.compareAnnotatedField(f, (AnnotatedField)fields.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        if (t1.getMethods().size() != t2.getMethods().size()) {
            return false;
        }
        HashMap<Method, AnnotatedMethod> methods = new HashMap<Method, AnnotatedMethod>();
        for (AnnotatedMethod f : t2.getMethods()) {
            methods.put(f.getJavaMember(), f);
        }
        for (AnnotatedMethod f : t1.getMethods()) {
            if (methods.containsKey(f.getJavaMember())) {
                if (Annotateds.compareAnnotatedCallable(f, (AnnotatedCallable)methods.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        if (t1.getConstructors().size() != t2.getConstructors().size()) {
            return false;
        }
        HashMap<Constructor, AnnotatedConstructor> constructors = new HashMap<Constructor, AnnotatedConstructor>();
        for (AnnotatedConstructor f : t2.getConstructors()) {
            constructors.put(f.getJavaMember(), f);
        }
        for (AnnotatedConstructor f : t1.getConstructors()) {
            if (constructors.containsKey(f.getJavaMember())) {
                if (Annotateds.compareAnnotatedCallable(f, (AnnotatedCallable)constructors.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static <X> boolean hasMethodParameters(AnnotatedCallable<X> callable) {
        for (AnnotatedParameter parameter : callable.getParameters()) {
            if (parameter.getAnnotations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static String createAnnotationCollectionId(Collection<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.size());
        annotationList.addAll(annotations);
        Collections.sort(annotationList, AnnotationComparator.INSTANCE);
        for (Annotation a : annotationList) {
            builder.append('@');
            builder.append(a.annotationType().getName());
            builder.append('(');
            Method[] declaredMethods = a.annotationType().getDeclaredMethods();
            ArrayList<Method> methods = new ArrayList<Method>(declaredMethods.length);
            methods.addAll(Arrays.asList(declaredMethods));
            Collections.sort(methods, MethodComparator.INSTANCE);
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                try {
                    Object value = method.invoke((Object)a, new Object[0]);
                    builder.append(method.getName());
                    builder.append('=');
                    builder.append(value.toString());
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("NullPointerException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("IllegalArgumentException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("IllegalAccessException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("InvocationTargetException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                if (i + 1 == methods.size()) continue;
                builder.append(',');
            }
            builder.append(')');
        }
        builder.append(']');
        return builder.toString();
    }

    private static boolean compareAnnotated(Annotated a1, Annotated a2) {
        return a1.getAnnotations().equals(a2.getAnnotations());
    }

    private static boolean compareAnnotatedParameters(List<? extends AnnotatedParameter<?>> p1, List<? extends AnnotatedParameter<?>> p2) {
        if (p1.size() != p2.size()) {
            return false;
        }
        for (int i = 0; i < p1.size(); ++i) {
            if (Annotateds.compareAnnotated((Annotated)p1.get(i), (Annotated)p2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Typed
    private static class MethodComparator
    implements Comparator<Method> {
        public static final Comparator<Method> INSTANCE = new MethodComparator();

        private MethodComparator() {
        }

        @Override
        public int compare(Method arg0, Method arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    @Typed
    private static class AnnotationComparator
    implements Comparator<Annotation>,
    Serializable {
        public static final Comparator<Annotation> INSTANCE = new AnnotationComparator();

        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation arg0, Annotation arg1) {
            return arg0.annotationType().getName().compareTo(arg1.annotationType().getName());
        }
    }

    @Typed
    private static class AnnotatedFieldComparator<T>
    implements Comparator<AnnotatedField<? super T>>,
    Serializable {
        private AnnotatedFieldComparator() {
        }

        public static <T> Comparator<AnnotatedField<? super T>> instance() {
            return new AnnotatedFieldComparator<T>();
        }

        @Override
        public int compare(AnnotatedField<? super T> arg0, AnnotatedField<? super T> arg1) {
            if (arg0.getJavaMember().getName().equals(arg1.getJavaMember().getName())) {
                return arg0.getJavaMember().getDeclaringClass().getName().compareTo(arg1.getJavaMember().getDeclaringClass().getName());
            }
            return arg0.getJavaMember().getName().compareTo(arg1.getJavaMember().getName());
        }
    }

    @Typed
    private static class AnnotatedConstructorComparator<T>
    implements Comparator<AnnotatedConstructor<? super T>>,
    Serializable {
        private AnnotatedCallableComparator<T> callableComparator = new AnnotatedCallableComparator();

        private AnnotatedConstructorComparator() {
        }

        public static <T> Comparator<AnnotatedConstructor<? super T>> instance() {
            return new AnnotatedConstructorComparator<T>();
        }

        @Override
        public int compare(AnnotatedConstructor<? super T> arg0, AnnotatedConstructor<? super T> arg1) {
            int result = this.callableComparator.compare((AnnotatedCallable<? super T>)arg0, (AnnotatedCallable<? super T>)arg1);
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < arg0.getJavaMember().getParameterTypes().length; ++i) {
                Class<?> p0 = arg0.getJavaMember().getParameterTypes()[i];
                Class<?> p1 = arg1.getJavaMember().getParameterTypes()[i];
                result = p0.getName().compareTo(p1.getName());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    @Typed
    private static class AnnotatedMethodComparator<T>
    implements Comparator<AnnotatedMethod<? super T>>,
    Serializable {
        private AnnotatedCallableComparator<T> callableComparator = new AnnotatedCallableComparator();

        private AnnotatedMethodComparator() {
        }

        public static <T> Comparator<AnnotatedMethod<? super T>> instance() {
            return new AnnotatedMethodComparator<T>();
        }

        @Override
        public int compare(AnnotatedMethod<? super T> arg0, AnnotatedMethod<? super T> arg1) {
            int result = this.callableComparator.compare((AnnotatedCallable<? super T>)arg0, (AnnotatedCallable<? super T>)arg1);
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < arg0.getJavaMember().getParameterTypes().length; ++i) {
                Class<?> p0 = arg0.getJavaMember().getParameterTypes()[i];
                Class<?> p1 = arg1.getJavaMember().getParameterTypes()[i];
                result = p0.getName().compareTo(p1.getName());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    @Typed
    private static class AnnotatedCallableComparator<T>
    implements Comparator<AnnotatedCallable<? super T>>,
    Serializable {
        private AnnotatedCallableComparator() {
        }

        @Override
        public int compare(AnnotatedCallable<? super T> arg0, AnnotatedCallable<? super T> arg1) {
            int result = arg0.getJavaMember().getName().compareTo(arg1.getJavaMember().getName());
            if (result != 0) {
                return result;
            }
            result = arg0.getJavaMember().getDeclaringClass().getName().compareTo(arg1.getJavaMember().getDeclaringClass().getName());
            if (result != 0) {
                return result;
            }
            result = arg0.getParameters().size() - arg1.getParameters().size();
            return result;
        }
    }
}

