/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.deltaspike.core.api.config.ConfigResolverContext;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.spi.config.ConfigFilter;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.core.util.ServiceUtils;

@Typed
public final class ConfigResolver {
    public static final String DELTASPIKE_APP_NAME_CONFIG = "deltaspike.application.name";
    public static final String DELTASPIKE_LOG_CONFIG = "deltaspike.config.log";
    private static final Logger LOG = Logger.getLogger(ConfigResolver.class.getName());
    private static Map<ClassLoader, ConfigSource[]> configSources = new ConcurrentHashMap<ClassLoader, ConfigSource[]>();
    private static Map<ClassLoader, List<ConfigFilter>> configFilters = new ConcurrentHashMap<ClassLoader, List<ConfigFilter>>();

    private ConfigResolver() {
    }

    public static synchronized void addConfigSources(List<ConfigSource> configSourcesToAdd) {
        ConfigResolver.getConfigSources();
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        ConfigSource[] configuredConfigSources = configSources.get(currentClassLoader);
        ArrayList<ConfigSource> allConfigSources = new ArrayList<ConfigSource>();
        allConfigSources.addAll(Arrays.asList(configuredConfigSources));
        allConfigSources.addAll(configSourcesToAdd);
        configSources.put(currentClassLoader, ConfigResolver.sortDescending(allConfigSources));
    }

    public static synchronized void freeConfigSources() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        configSources.remove(classLoader);
        configFilters.remove(classLoader);
    }

    public static void addConfigFilter(ConfigFilter configFilter) {
        List<ConfigFilter> currentConfigFilters = ConfigResolver.getInternalConfigFilters();
        currentConfigFilters.add(configFilter);
    }

    public static List<ConfigFilter> getConfigFilters() {
        return Collections.unmodifiableList(ConfigResolver.getInternalConfigFilters());
    }

    private static List<ConfigFilter> getInternalConfigFilters() {
        ClassLoader cl = ClassUtils.getClassLoader(null);
        List<ConfigFilter> currentConfigFilters = configFilters.get(cl);
        if (currentConfigFilters == null) {
            currentConfigFilters = new CopyOnWriteArrayList<ConfigFilter>();
            configFilters.put(cl, currentConfigFilters);
        }
        return currentConfigFilters;
    }

    public static String getPropertyValue(String key, String defaultValue) {
        return ConfigResolver.getPropertyValue(key, defaultValue, true);
    }

    public static String getPropertyValue(String key, String defaultValue, boolean evaluateVariables) {
        ConfigResolverContext configResolverContext = evaluateVariables ? ConfigResolverContext.EVAL_VARIABLES : ConfigResolverContext.NONE;
        String value = ConfigResolver.getPropertyValue(key, configResolverContext);
        return ConfigResolver.fallbackToDefaultIfEmpty(key, value, defaultValue, configResolverContext);
    }

    public static String getPropertyValue(String key) {
        return ConfigResolver.getPropertyValue(key, new ConfigResolverContext().setEvaluateVariables(true));
    }

    public static String getPropertyValue(String key, boolean evaluateVariables) {
        return ConfigResolver.getPropertyValue(key, evaluateVariables ? ConfigResolverContext.EVAL_VARIABLES : ConfigResolverContext.NONE);
    }

    public static String getProjectStageAwarePropertyValue(String key) {
        ConfigResolverContext configResolverContext = ConfigResolverContext.PROJECTSTAGE_EVAL_VARIABLES;
        ProjectStage ps = ConfigResolver.getProjectStage();
        String value = ConfigResolver.getPropertyValue(key + '.' + ps, configResolverContext);
        if (value == null) {
            value = ConfigResolver.getPropertyValue(key, configResolverContext);
        }
        return value;
    }

    public static String getProjectStageAwarePropertyValue(String key, String defaultValue) {
        String value = ConfigResolver.getProjectStageAwarePropertyValue(key);
        return ConfigResolver.fallbackToDefaultIfEmpty(key, value, defaultValue, ConfigResolverContext.PROJECTSTAGE_EVAL_VARIABLES);
    }

    public static String getPropertyAwarePropertyValue(String key, String property) {
        String propertyValue = ConfigResolver.getProjectStageAwarePropertyValue(property);
        String value = null;
        if (propertyValue != null && propertyValue.length() > 0) {
            value = ConfigResolver.getProjectStageAwarePropertyValue(key + '.' + propertyValue);
        }
        if (value == null) {
            value = ConfigResolver.getProjectStageAwarePropertyValue(key);
        }
        return value;
    }

    public static String getPropertyAwarePropertyValue(String key, String property, String defaultValue) {
        String value = ConfigResolver.getPropertyAwarePropertyValue(key, property);
        return ConfigResolver.fallbackToDefaultIfEmpty(key, value, defaultValue, ConfigResolverContext.PROJECTSTAGE_EVAL_VARIABLES);
    }

    private static String getPropertyValue(String key, ConfigResolverContext configResolverContext) {
        ConfigSource[] appConfigSources;
        for (ConfigSource configSource : appConfigSources = ConfigResolver.getConfigSources()) {
            String value = configSource.getPropertyValue(key);
            if (value != null) {
                LOG.log(Level.FINE, "found value {0} for key {1} in ConfigSource {2}.", new Object[]{ConfigResolver.filterConfigValueForLog(key, value), key, configSource.getConfigName()});
                if (configResolverContext.isEvaluateVariables()) {
                    value = ConfigResolver.resolveVariables(value, configResolverContext);
                }
                return ConfigResolver.filterConfigValue(key, value);
            }
            LOG.log(Level.FINER, "NO value found for key {0} in ConfigSource {1}.", new Object[]{key, configSource.getConfigName()});
        }
        return null;
    }

    private static String resolveVariables(String value, ConfigResolverContext configResolverContext) {
        String varName;
        int endVar;
        int startVar = 0;
        while ((startVar = value.indexOf("${", startVar)) >= 0 && (endVar = value.indexOf("}", startVar)) > 0 && !(varName = value.substring(startVar + 2, endVar)).isEmpty()) {
            String variableValue = configResolverContext.isProjectStageAware() ? ConfigResolver.getProjectStageAwarePropertyValue(varName) : ConfigResolver.getPropertyValue(varName, true);
            if (variableValue != null) {
                value = value.replace("${" + varName + "}", variableValue);
            }
            ++startVar;
        }
        return value;
    }

    public static List<String> getAllPropertyValues(String key) {
        List<ConfigSource> appConfigSources = ConfigResolver.sortAscending(new ArrayList<ConfigSource>(Arrays.asList(ConfigResolver.getConfigSources())));
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigSource configSource : appConfigSources) {
            String value = configSource.getPropertyValue(key);
            if (value == null || result.contains(value = ConfigResolver.filterConfigValue(key, value))) continue;
            result.add(value);
        }
        return result;
    }

    public static Map<String, String> getAllProperties() {
        List<ConfigSource> appConfigSources = ConfigResolver.sortAscending(new ArrayList<ConfigSource>(Arrays.asList(ConfigResolver.getConfigSources())));
        HashMap<String, String> result = new HashMap<String, String>();
        for (ConfigSource configSource : appConfigSources) {
            if (!configSource.isScannable()) continue;
            result.putAll(configSource.getProperties());
        }
        return Collections.unmodifiableMap(result);
    }

    public static synchronized ConfigSource[] getConfigSources() {
        ClassLoader currentClassLoader = ClassUtils.getClassLoader(null);
        ConfigSource[] appConfigSources = configSources.get(currentClassLoader);
        if (appConfigSources == null) {
            appConfigSources = ConfigResolver.sortDescending(ConfigResolver.resolveConfigSources());
            if (LOG.isLoggable(Level.FINE)) {
                for (ConfigSource cs : appConfigSources) {
                    LOG.log(Level.FINE, "Adding ordinal {0} ConfigSource {1}", new Object[]{cs.getOrdinal(), cs.getConfigName()});
                }
            }
            configSources.put(currentClassLoader, appConfigSources);
        }
        return appConfigSources;
    }

    private static List<ConfigSource> resolveConfigSources() {
        List<ConfigSource> appConfigSources = ServiceUtils.loadServiceImplementations(ConfigSource.class);
        List<ConfigSourceProvider> configSourceProviderServiceLoader = ServiceUtils.loadServiceImplementations(ConfigSourceProvider.class);
        for (ConfigSourceProvider configSourceProvider : configSourceProviderServiceLoader) {
            appConfigSources.addAll(configSourceProvider.getConfigSources());
        }
        List<ConfigFilter> configFilters = ServiceUtils.loadServiceImplementations(ConfigFilter.class);
        for (ConfigFilter configFilter : configFilters) {
            ConfigResolver.addConfigFilter(configFilter);
        }
        return appConfigSources;
    }

    private static ConfigSource[] sortDescending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? -1 : 1;
            }
        });
        return configSources.toArray(new ConfigSource[configSources.size()]);
    }

    private static List<ConfigSource> sortAscending(List<ConfigSource> configSources) {
        Collections.sort(configSources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource configSource1, ConfigSource configSource2) {
                return configSource1.getOrdinal() > configSource2.getOrdinal() ? 1 : -1;
            }
        });
        return configSources;
    }

    private static ProjectStage getProjectStage() {
        return ProjectStageProducer.getInstance().getProjectStage();
    }

    private static <T> T fallbackToDefaultIfEmpty(String key, T value, T defaultValue, ConfigResolverContext configResolverContext) {
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            if (configResolverContext != null && defaultValue instanceof String && configResolverContext.isEvaluateVariables()) {
                defaultValue = ConfigResolver.resolveVariables((String)defaultValue, configResolverContext);
            }
            LOG.log(Level.FINE, "no configured value found for key {0}, using default value {1}.", new Object[]{key, defaultValue});
            return defaultValue;
        }
        return value;
    }

    public static String filterConfigValue(String key, String value) {
        List<ConfigFilter> currentConfigFilters = ConfigResolver.getInternalConfigFilters();
        String filteredValue = value;
        for (ConfigFilter filter : currentConfigFilters) {
            filteredValue = filter.filterValue(key, filteredValue);
        }
        return filteredValue;
    }

    public static String filterConfigValueForLog(String key, String value) {
        List<ConfigFilter> currentConfigFilters = ConfigResolver.getInternalConfigFilters();
        String logValue = value;
        for (ConfigFilter filter : currentConfigFilters) {
            logValue = filter.filterValueForLog(key, logValue);
        }
        return logValue;
    }

    public static UntypedResolver<String> resolve(String name) {
        return new PropertyBuilder<String>(name);
    }

    private static class PropertyBuilder<T>
    implements UntypedResolver<T> {
        private String keyOriginal;
        private String keyResolved;
        private Type configEntryType = String.class;
        private boolean withDefault = false;
        private T defaultValue;
        private boolean projectStageAware = true;
        private String propertyParameter;
        private String parameterValue;
        private boolean strictly = false;
        private boolean isList = false;
        private Converter<?> converter;
        private boolean evaluateVariables = false;
        private boolean logChanges = false;
        private long cacheTimeMs = -1L;
        private volatile long reloadAfter = -1L;
        private T lastValue = null;

        private PropertyBuilder() {
        }

        protected PropertyBuilder(String propertyName) {
            this.keyOriginal = propertyName;
        }

        @Override
        public <N> TypedResolver<N> as(Class<N> clazz) {
            this.configEntryType = clazz;
            return this;
        }

        @Override
        public TypedResolver<List<T>> asList() {
            this.isList = true;
            PropertyBuilder listTypedResolver = this;
            if (this.defaultValue == null) {
                return listTypedResolver.withDefault(Collections.emptyList());
            }
            return listTypedResolver;
        }

        @Override
        public <N> TypedResolver<N> as(Class<N> clazz, Converter<N> converter) {
            this.configEntryType = clazz;
            this.converter = converter;
            return this;
        }

        @Override
        public <N> TypedResolver<N> as(Type clazz, Converter<N> converter) {
            this.configEntryType = clazz;
            this.converter = converter;
            return this;
        }

        @Override
        public TypedResolver<T> withDefault(T value) {
            this.defaultValue = value;
            this.withDefault = true;
            return this;
        }

        @Override
        public TypedResolver<T> withStringDefault(String value) {
            if (value == null || value.isEmpty()) {
                throw new RuntimeException("Empty String or null supplied as string-default value for property " + this.keyOriginal);
            }
            this.defaultValue = this.isList ? this.splitAndConvertListValue(value) : this.convert(value);
            this.withDefault = true;
            return this;
        }

        @Override
        public TypedResolver<T> cacheFor(TimeUnit timeUnit, long value) {
            this.cacheTimeMs = timeUnit.toMillis(value);
            return this;
        }

        @Override
        public TypedResolver<T> parameterizedBy(String propertyName) {
            String parameterValue;
            this.propertyParameter = propertyName;
            if (this.propertyParameter != null && !this.propertyParameter.isEmpty() && (parameterValue = (String)ConfigResolver.resolve(this.propertyParameter).withCurrentProjectStage(this.projectStageAware).getValue()) != null && !parameterValue.isEmpty()) {
                this.parameterValue = parameterValue;
            }
            return this;
        }

        @Override
        public TypedResolver<T> withCurrentProjectStage(boolean with) {
            this.projectStageAware = with;
            return this;
        }

        @Override
        public TypedResolver<T> strictly(boolean strictly) {
            this.strictly = strictly;
            return this;
        }

        @Override
        public TypedResolver<T> evaluateVariables(boolean evaluateVariables) {
            this.evaluateVariables = evaluateVariables;
            return this;
        }

        @Override
        public TypedResolver<T> logChanges(boolean logChanges) {
            this.logChanges = logChanges;
            return this;
        }

        @Override
        public T getValue() {
            long now = -1L;
            if (this.cacheTimeMs > 0L && (now = System.currentTimeMillis()) <= this.reloadAfter) {
                return this.lastValue;
            }
            String valueStr = this.resolveStringValue();
            Object value = this.isList ? this.splitAndConvertListValue(valueStr) : this.convert(valueStr);
            if (this.withDefault) {
                ConfigResolverContext configResolverContext = new ConfigResolverContext().setEvaluateVariables(this.evaluateVariables).setProjectStageAware(this.projectStageAware);
                value = ConfigResolver.fallbackToDefaultIfEmpty(this.keyResolved, value, this.defaultValue, configResolverContext);
                if (this.isList && String.class.isInstance(value)) {
                    value = this.splitAndConvertListValue((String)String.class.cast(value));
                }
            }
            if (this.logChanges && (value != null && !value.equals(this.lastValue) || value == null && this.lastValue != null)) {
                LOG.log(Level.INFO, "New value {0} for key {1}.", new Object[]{ConfigResolver.filterConfigValueForLog(this.keyOriginal, valueStr), this.keyOriginal});
            }
            this.lastValue = value;
            if (this.cacheTimeMs > 0L) {
                this.reloadAfter = now + this.cacheTimeMs;
            }
            return value;
        }

        private T splitAndConvertListValue(String valueStr) {
            if (valueStr == null) {
                return null;
            }
            ArrayList<T> list = new ArrayList<T>();
            StringBuilder currentValue = new StringBuilder();
            int length = valueStr.length();
            for (int i = 0; i < length; ++i) {
                char c = valueStr.charAt(i);
                if (c == '\\') {
                    if (i >= length - 1) continue;
                    char nextC = valueStr.charAt(i + 1);
                    currentValue.append(nextC);
                    ++i;
                    continue;
                }
                if (c == ',') {
                    String trimedVal = currentValue.toString().trim();
                    if (trimedVal.length() > 0) {
                        list.add(this.convert(trimedVal));
                    }
                    currentValue.setLength(0);
                    continue;
                }
                currentValue.append(c);
            }
            String trimedVal = currentValue.toString().trim();
            if (trimedVal.length() > 0) {
                list.add(this.convert(trimedVal));
            }
            return (T)list;
        }

        @Override
        public String getKey() {
            return this.keyOriginal;
        }

        @Override
        public String getResolvedKey() {
            return this.keyResolved;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }

        private String resolveStringValue() {
            ProjectStage ps = null;
            String value = null;
            this.keyResolved = this.keyOriginal;
            int keySuffices = 0;
            if (this.propertyParameter != null && !this.propertyParameter.isEmpty()) {
                if (this.parameterValue != null && !this.parameterValue.isEmpty()) {
                    this.keyResolved = this.keyResolved + "." + this.parameterValue;
                    ++keySuffices;
                } else if (this.strictly) {
                    return null;
                }
            }
            if (this.projectStageAware) {
                ps = ConfigResolver.getProjectStage();
                this.keyResolved = this.keyResolved + "." + ps;
                ++keySuffices;
            }
            if ((value = ConfigResolver.getPropertyValue(this.keyResolved, this.evaluateVariables)) == null && !this.strictly) {
                switch (keySuffices) {
                    case 2: {
                        this.keyResolved = this.keyOriginal + "." + this.parameterValue;
                        value = ConfigResolver.getPropertyValue(this.keyResolved, null, this.evaluateVariables);
                        if (value != null) {
                            return value;
                        }
                        ps = ConfigResolver.getProjectStage();
                        this.keyResolved = this.keyOriginal + "." + ps;
                        value = ConfigResolver.getPropertyValue(this.keyResolved, null, this.evaluateVariables);
                        if (value != null) {
                            return value;
                        }
                    }
                    case 1: {
                        this.keyResolved = this.keyOriginal;
                        value = ConfigResolver.getPropertyValue(this.keyResolved, null, this.evaluateVariables);
                        return value;
                    }
                }
                return null;
            }
            return value;
        }

        private T convert(String value) {
            if (value == null) {
                return null;
            }
            Object result = null;
            if (this.converter != null) {
                try {
                    result = this.converter.convert(value);
                }
                catch (Exception e) {
                    throw ExceptionUtils.throwAsRuntimeException(e);
                }
            } else if (String.class.equals((Object)this.configEntryType)) {
                result = value;
            } else if (Class.class.equals((Object)this.configEntryType)) {
                result = ClassUtils.tryToLoadClassForName(value);
            } else if (Boolean.class.equals((Object)this.configEntryType)) {
                Boolean isTrue = "TRUE".equalsIgnoreCase(value);
                isTrue = isTrue | "1".equalsIgnoreCase(value);
                isTrue = isTrue | "YES".equalsIgnoreCase(value);
                isTrue = isTrue | "Y".equalsIgnoreCase(value);
                isTrue = isTrue | "JA".equalsIgnoreCase(value);
                isTrue = isTrue | "J".equalsIgnoreCase(value);
                isTrue = isTrue | "OUI".equalsIgnoreCase(value);
                result = isTrue;
            } else if (Integer.class.equals((Object)this.configEntryType)) {
                result = Integer.parseInt(value);
            } else if (Long.class.equals((Object)this.configEntryType)) {
                result = Long.parseLong(value);
            } else if (Float.class.equals((Object)this.configEntryType)) {
                result = Float.valueOf(Float.parseFloat(value));
            } else if (Double.class.equals((Object)this.configEntryType)) {
                result = Double.parseDouble(value);
            }
            return (T)result;
        }
    }

    public static interface UntypedResolver<T>
    extends TypedResolver<T> {
        public <N> TypedResolver<N> as(Class<N> var1);

        public <N> TypedResolver<N> as(Type var1, Converter<N> var2);

        public <N> TypedResolver<N> as(Class<N> var1, Converter<N> var2);
    }

    public static interface TypedResolver<T> {
        public TypedResolver<List<T>> asList();

        public TypedResolver<T> parameterizedBy(String var1);

        public TypedResolver<T> withCurrentProjectStage(boolean var1);

        public TypedResolver<T> strictly(boolean var1);

        public TypedResolver<T> withDefault(T var1);

        public TypedResolver<T> withStringDefault(String var1);

        public TypedResolver<T> cacheFor(TimeUnit var1, long var2);

        public TypedResolver<T> evaluateVariables(boolean var1);

        public TypedResolver<T> logChanges(boolean var1);

        public T getValue();

        public String getKey();

        public String getResolvedKey();

        public T getDefaultValue();
    }

    public static interface Converter<T> {
        public T convert(String var1);
    }
}

