/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.model;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public final class NotificationContainerProxy
implements ContainerSchemaNode {
    private final Set<AugmentationSchemaNode> availableAugmentations;
    private final Map<QName, DataSchemaNode> childNodes = new HashMap<QName, DataSchemaNode>();
    private final QName qname;

    public NotificationContainerProxy(NotificationDefinition def) {
        this.availableAugmentations = def.getAvailableAugmentations();
        for (DataSchemaNode element : def.getChildNodes()) {
            this.childNodes.put(element.getQName(), element);
        }
        this.qname = def.getQName();
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return Collections.emptySet();
    }

    public Set<DataSchemaNode> getChildNodes() {
        return Sets.newHashSet(this.childNodes.values());
    }

    public Set<GroupingDefinition> getGroupings() {
        return Collections.emptySet();
    }

    @Deprecated
    public DataSchemaNode getDataChildByName(QName child) {
        return this.childNodes.get(child);
    }

    public Set<UsesNode> getUses() {
        return Collections.emptySet();
    }

    public boolean isPresenceContainer() {
        throw new UnsupportedOperationException();
    }

    public Set<AugmentationSchemaNode> getAvailableAugmentations() {
        return this.availableAugmentations;
    }

    public boolean isAugmenting() {
        throw new UnsupportedOperationException();
    }

    public boolean isAddedByUses() {
        throw new UnsupportedOperationException();
    }

    public boolean isConfiguration() {
        throw new UnsupportedOperationException();
    }

    public QName getQName() {
        return this.qname;
    }

    public SchemaPath getPath() {
        return SchemaPath.create((boolean)true, (QName[])new QName[]{this.qname});
    }

    public Status getStatus() {
        throw new UnsupportedOperationException();
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return Optional.empty();
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public Optional<String> getReference() {
        return Optional.empty();
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return Optional.empty();
    }

    public Set<NotificationDefinition> getNotifications() {
        return Collections.emptySet();
    }

    public Set<ActionDefinition> getActions() {
        return Collections.emptySet();
    }

    public Collection<MustDefinition> getMustConstraints() {
        return Collections.emptyList();
    }
}

