/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Endpoint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.config.ConfiguredEndpoints;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class Util {
    private static final String ERR_UNRECOGNIZED_STORE = "Unrecognized store value %s";
    private static final Gson GSON = new Gson();
    private static final BiMap<Integer, LogicalDatastoreType> STORE_MAP = ImmutableBiMap.builder().put((Object)0, (Object)LogicalDatastoreType.CONFIGURATION).put((Object)1, (Object)LogicalDatastoreType.OPERATIONAL).build();
    private static final BiMap<String, Integer> STORE_STR_MAP = ImmutableBiMap.builder().put((Object)"config", (Object)0).put((Object)"operational", (Object)1).build();

    private Util() {
    }

    public static LogicalDatastoreType int2store(int store) {
        LogicalDatastoreType ldt = (LogicalDatastoreType)STORE_MAP.get((Object)store);
        Preconditions.checkNotNull((Object)ldt, (String)ERR_UNRECOGNIZED_STORE, (int)store);
        return ldt;
    }

    public static int store2int(String store) {
        try {
            return Integer.parseInt(store);
        }
        catch (NumberFormatException e) {
            Integer s = (Integer)STORE_STR_MAP.get((Object)store);
            Preconditions.checkNotNull((Object)s, (String)ERR_UNRECOGNIZED_STORE, (Object)store);
            return s;
        }
    }

    public static int store2int(@Nonnull LogicalDatastoreType store) {
        Preconditions.checkNotNull((Object)store);
        Integer ldt = (Integer)STORE_MAP.inverse().get((Object)store);
        Preconditions.checkNotNull((Object)ldt, (String)ERR_UNRECOGNIZED_STORE, (Object)store);
        return ldt;
    }

    public static String store2str(int store) {
        String s = (String)STORE_STR_MAP.inverse().get((Object)store);
        Preconditions.checkNotNull((Object)s, (String)ERR_UNRECOGNIZED_STORE, (int)store);
        return s;
    }

    public static void closeNullable(@Nullable AutoCloseable closeable) throws Exception {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void populateFromEndpointList(HierarchicalEnumMap<JsonElement, DataType, String> pathMap, Collection<? extends Endpoint> endpoints, DataType key) {
        endpoints.stream().filter(p -> p != null && p.getEndpointUri() != null).forEach(ep -> pathMap.put((JsonElement)GSON.fromJson(ep.getPath(), JsonObject.class), key, ep.getEndpointUri().getValue()));
    }

    public static void closeNullableWithExceptionCallback(@Nullable AutoCloseable closeable, @Nonnull Consumer<Exception> callback) {
        try {
            Util.closeNullable(closeable);
        }
        catch (Exception e) {
            callback.accept(e);
        }
    }

    public static YangInstanceIdentifier createBiPath(String name) {
        YangInstanceIdentifier.InstanceIdentifierBuilder builder = YangInstanceIdentifier.builder();
        builder.node(Config.QNAME).node(ConfiguredEndpoints.QNAME).nodeWithKey(ConfiguredEndpoints.QNAME, QName.create((URI)ConfiguredEndpoints.QNAME.getNamespace(), (Optional)ConfiguredEndpoints.QNAME.getRevision(), (String)"name"), (Object)name);
        return builder.build();
    }

    static Optional<Module> findModuleWithLatestRevision(SchemaContext schemaContext, String name) {
        return schemaContext.findModules(name).stream().findFirst();
    }
}

