/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.impl.AbstractJsonRPCComponent;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.JsonRPCTx;
import org.opendaylight.jsonrpc.model.TransactionListener;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxChain
extends AbstractJsonRPCComponent
implements DOMTransactionChain,
TransactionListener {
    private static final Logger LOG = LoggerFactory.getLogger(TxChain.class);
    private final DOMDataBroker dataBroker;
    private final DOMTransactionChainListener listener;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private JsonRPCTx currentTransaction = null;
    private volatile boolean closed = false;
    private volatile boolean successful = true;
    @GuardedBy(value="rwLock")
    private final ConcurrentMap<DOMDataTreeWriteTransaction, AutoCloseable> pendingTransactions = Maps.newConcurrentMap();

    public TxChain(@Nonnull DOMDataBroker dataBroker, @Nonnull DOMTransactionChainListener listener, @Nonnull TransportFactory transportFactory, @Nonnull HierarchicalEnumMap<JsonElement, DataType, String> pathMap, @Nonnull JsonConverter jsonConverter, @Nonnull SchemaContext schemaContext, @Nonnull Peer peer) {
        super(schemaContext, transportFactory, pathMap, jsonConverter, peer);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.listener = Objects.requireNonNull(listener);
    }

    public synchronized DOMDataTreeReadTransaction newReadOnlyTransaction() {
        this.checkOperationPermitted();
        return this.dataBroker.newReadOnlyTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonRPCTx getWriteTransaction() {
        this.checkOperationPermitted();
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            DOMDataTreeWriteTransaction writeTransaction = this.dataBroker.newWriteOnlyTransaction();
            Preconditions.checkState((boolean)(writeTransaction instanceof JsonRPCTx));
            JsonRPCTx pendingWriteTx = (JsonRPCTx)writeTransaction;
            this.pendingTransactions.put((DOMDataTreeWriteTransaction)pendingWriteTx, pendingWriteTx.addCallback(this));
            this.currentTransaction = pendingWriteTx;
            JsonRPCTx jsonRPCTx = pendingWriteTx;
            return jsonRPCTx;
        }
        finally {
            lock.unlock();
        }
    }

    public JsonRPCTx newWriteOnlyTransaction() {
        return this.getWriteTransaction();
    }

    public JsonRPCTx newReadWriteTransaction() {
        return this.getWriteTransaction();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyChainListenerSuccess();
        }
    }

    private void checkOperationPermitted() {
        if (this.closed) {
            throw new DOMTransactionChainClosedException("Transaction chain was closed");
        }
        Preconditions.checkState((boolean)Objects.isNull(this.currentTransaction), (Object)"Last write transaction has not finished yet");
    }

    private void notifyChainListenerSuccess() {
        if (this.closed && this.successful && this.pendingTransactions.isEmpty()) {
            this.listener.onTransactionChainSuccessful((DOMTransactionChain)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTx(JsonRPCTx tx) {
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            ((AutoCloseable)Optional.fromNullable(this.pendingTransactions.remove(tx)).or(() -> {})).close();
        }
        catch (Exception e) {
            LOG.error("Failed to remove pending transaction {}", (Object)tx, (Object)e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void onCancel(JsonRPCTx jsonRPCTx) {
        this.removeTx(jsonRPCTx);
        this.currentTransaction = null;
    }

    @Override
    public void onSuccess(JsonRPCTx tx) {
        this.removeTx(tx);
        this.notifyChainListenerSuccess();
    }

    @Override
    public void onFailure(JsonRPCTx tx, Throwable failure) {
        this.removeTx(tx);
        this.successful = false;
        if (this.currentTransaction != null) {
            this.currentTransaction.cancel();
        }
        this.listener.onTransactionChainFailed((DOMTransactionChain)this, (DOMDataTreeTransaction)tx, failure);
    }

    @Override
    public void onSubmit(JsonRPCTx jsonRPCTx) {
        this.currentTransaction = null;
    }
}

