/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import java.util.NoSuchElementException;
import org.opendaylight.jsonrpc.bus.messagelib.EndpointBuilders;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.hmap.DataType;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.impl.AbstractJsonRPCComponent;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.model.RemoteOmShard;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

abstract class RemoteShardAware
extends AbstractJsonRPCComponent
implements AutoCloseable {
    private final LoadingCache<String, RemoteOmShard> shardCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, RemoteOmShard>(){

        public RemoteOmShard load(String uri) throws Exception {
            return (RemoteOmShard)((EndpointBuilders.RequesterBuilder)RemoteShardAware.this.transportFactory.endpointBuilder().requester().useCache()).createProxy(RemoteOmShard.class, uri);
        }
    });

    RemoteShardAware(SchemaContext schemaContext, TransportFactory transportFactory, HierarchicalEnumMap<JsonElement, DataType, String> pathMap, JsonConverter jsonConverter, Peer peer) {
        super(schemaContext, transportFactory, pathMap, jsonConverter, peer);
    }

    protected RemoteOmShard getShard(LogicalDatastoreType store, JsonElement path) {
        return (RemoteOmShard)this.shardCache.getUnchecked((Object)this.lookupEndPoint(store, path));
    }

    protected String lookupEndPoint(LogicalDatastoreType store, JsonElement path) {
        return (String)this.pathMap.lookup(path, DataType.forDatastore(store)).orElseThrow(NoSuchElementException::new);
    }

    @Override
    public void close() {
        this.shardCache.asMap().values().stream().forEach(RemoteOmShard::close);
        this.shardCache.asMap().clear();
    }
}

