/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.impl.DataChangeListenerRegistry;
import org.opendaylight.jsonrpc.impl.DataModificationContext;
import org.opendaylight.jsonrpc.impl.EnsureParentTransactionFactory;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.Util;
import org.opendaylight.jsonrpc.impl.YangInstanceIdentifierDeserializer;
import org.opendaylight.jsonrpc.model.ListenerKey;
import org.opendaylight.jsonrpc.model.RemoteOmShard;
import org.opendaylight.jsonrpc.model.TransactionFactory;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteControl
implements RemoteOmShard,
AutoCloseable {
    private static final long TRX_TTL_MILLIS = 900000L;
    private static final long TRX_CLEANUP_INTERVAL = 90000L;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteControl.class);
    private final DOMDataBroker domDataBroker;
    private final SchemaContext schemaContext;
    private final JsonConverter jsonConverter;
    private final ConcurrentMap<String, DataModificationContext> txmap = Maps.newConcurrentMap();
    private final ReadWriteLock trxGuard = new ReentrantReadWriteLock();
    private final Future<?> cleanerFuture;
    private final TransactionFactory transactionFactory;
    private final DataChangeListenerRegistry dataChangeRegistry;
    private final ScheduledExecutorService scheduledExecutorService;

    public RemoteControl(@Nonnull DOMDataBroker domDataBroker, @Nonnull SchemaContext schemaContext, TransportFactory transportFactory) {
        this(domDataBroker, schemaContext, 90000L, transportFactory);
    }

    public RemoteControl(@Nonnull DOMDataBroker domDataBroker, @Nonnull SchemaContext schemaContext, long cleanupIntervalMilliseconds, @Nonnull TransportFactory transportFactory) {
        this.domDataBroker = Objects.requireNonNull(domDataBroker);
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.jsonConverter = new JsonConverter(schemaContext);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("jsonrpc-tx-cleaner-%d").setDaemon(true).build());
        this.cleanerFuture = this.scheduledExecutorService.scheduleAtFixedRate(this::cleanupStaleTransactions, cleanupIntervalMilliseconds, cleanupIntervalMilliseconds, TimeUnit.MILLISECONDS);
        this.transactionFactory = new EnsureParentTransactionFactory(domDataBroker, Objects.requireNonNull(schemaContext));
        this.dataChangeRegistry = new DataChangeListenerRegistry(domDataBroker, transportFactory, this.jsonConverter);
    }

    private void cleanupStaleTransactions() {
        long now = System.currentTimeMillis();
        this.txmap.entrySet().removeIf(e -> !((DataModificationContext)e.getValue()).isSuccess() && ((DataModificationContext)e.getValue()).getCompletionTimestamp() != -1L && ((DataModificationContext)e.getValue()).getCompletionTimestamp() + 900000L > now);
    }

    @VisibleForTesting
    boolean isTxMapEmpty() {
        return this.txmap.entrySet().isEmpty();
    }

    @VisibleForTesting
    YangInstanceIdentifier path2II(JsonElement path) {
        return YangInstanceIdentifierDeserializer.toYangInstanceIdentifier(path, this.schemaContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonElement read(int store, String entity, JsonElement path) {
        YangInstanceIdentifier pathAsIId = this.path2II(path);
        LOG.debug("READ : YII :{}", (Object)pathAsIId);
        try (DOMDataTreeReadWriteTransaction rTrx = this.domDataBroker.newReadWriteTransaction();){
            NormalizedNode result = ((Optional)rTrx.read(Util.int2store(store), pathAsIId).get()).orElse(null);
            LOG.info("Result is {}", (Object)result);
            JsonElement jsonElement = this.jsonConverter.toBus(pathAsIId, result).getData();
            return jsonElement;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Read failed", e);
        }
    }

    @Override
    public JsonElement read(String store, String entity, JsonElement path) {
        return this.read(Util.store2int(store), entity, path);
    }

    @Override
    public void put(String txId, int store, String entity, JsonElement path, JsonElement data) {
        YangInstanceIdentifier pathAsIId = this.path2II(path);
        LOG.info("PUT txId : {}, store : {}, entity : {}, path : {}, YII :{}, data : {}", new Object[]{txId, Util.int2store(store), entity, path, pathAsIId, data});
        DOMDataTreeWriteTransaction wtx = this.allocateTrx(txId).getValue().newWriteTransaction();
        wtx.put(Util.int2store(store), pathAsIId, this.jsonConverter.jsonElementToNormalizedNode(this.injectQName(pathAsIId, data), pathAsIId));
    }

    @Override
    public void put(String txId, String store, String entity, JsonElement path, JsonElement data) {
        this.put(txId, Util.store2int(store), entity, path, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(int store, String entity, JsonElement path) {
        YangInstanceIdentifier pathAsIId = this.path2II(path);
        LOG.debug("EXISTS store={}, entity={}, path={}, YII={}", new Object[]{Util.int2store(store), entity, path, pathAsIId});
        try (DOMDataTreeReadTransaction trx = this.domDataBroker.newReadOnlyTransaction();){
            boolean bl = (Boolean)trx.exists(Util.int2store(store), pathAsIId).get();
            return bl;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Read failed", e);
        }
    }

    @Override
    public boolean exists(String store, String entity, JsonElement path) {
        return this.exists(Util.store2int(store), entity, path);
    }

    @Override
    public void merge(String txId, int store, String entity, JsonElement path, JsonElement data) {
        DOMDataTreeWriteTransaction trx = this.allocateTrx(txId).getValue().newWriteTransaction();
        YangInstanceIdentifier pathAsIId = this.path2II(path);
        LOG.debug("MERGE : tx={}, store={}, entity={}, path={}, YII={}, data={}", new Object[]{txId, Util.int2store(store), entity, path, pathAsIId, data});
        trx.merge(Util.int2store(store), pathAsIId, this.jsonConverter.jsonElementToNormalizedNode(data, pathAsIId, true));
    }

    @Override
    public void merge(String txId, String store, String entity, JsonElement path, JsonElement data) {
        this.merge(txId, Util.store2int(store), entity, path, data);
    }

    @Override
    public void delete(String txId, int store, String entity, JsonElement path) {
        YangInstanceIdentifier pathAsIId = this.path2II(path);
        LOG.debug("DELETE : tx={}, store={}, entity={}, path={}, YII={}", new Object[]{txId, Util.int2store(store), entity, path, pathAsIId});
        DOMDataTreeWriteTransaction trx = this.allocateTrx(txId).getValue().newWriteTransaction();
        trx.delete(Util.int2store(store), pathAsIId);
    }

    @Override
    public void delete(String txId, String store, String entity, JsonElement path) {
        this.delete(txId, Util.store2int(store), entity, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="trxGuard")
    public boolean commit(String txId) {
        LOG.debug("COMMIT : {}", (Object)txId);
        Lock lock = this.trxGuard.writeLock();
        try {
            lock.lock();
            if (!this.txmap.containsKey(txId)) {
                boolean bl = false;
                return bl;
            }
            boolean succeed = ((DataModificationContext)this.txmap.get(txId)).submit();
            if (succeed) {
                this.txmap.remove(txId);
            }
            boolean bl = succeed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean cancel(String txId) {
        LOG.debug("CANCEL : {}", (Object)txId);
        DataModificationContext rwTx = (DataModificationContext)this.txmap.remove(txId);
        return rwTx != null ? rwTx.cancel() : false;
    }

    @Override
    public String txid() {
        String ret = this.allocateTrx(null).getKey();
        LOG.debug("TXID : {}", (Object)ret);
        return ret;
    }

    @Override
    public List<String> error(String txId) {
        LOG.debug("ERROR : {}", (Object)txId);
        if (this.txmap.containsKey(txId) && !((DataModificationContext)this.txmap.get(txId)).isSuccess()) {
            return ((DataModificationContext)this.txmap.get(txId)).getErrors().stream().map(RemoteControl::serializeError).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @VisibleForTesting
    JsonElement injectQName(YangInstanceIdentifier yii, JsonElement inJson) {
        LOG.debug("Injecting QName from {} into JSON '{}'", (Object)yii, (Object)inJson);
        Set fields = ((JsonObject)inJson).entrySet();
        if (fields.isEmpty()) {
            return inJson;
        }
        Map.Entry firstNode = (Map.Entry)fields.iterator().next();
        if (((String)firstNode.getKey()).indexOf(58) != -1) {
            return inJson;
        }
        QName qn = yii.getLastPathArgument().getNodeType();
        JsonObject wrapper = new JsonObject();
        wrapper.add(qn.getLocalName(), inJson);
        LOG.info("Wrapped data : {}", (Object)wrapper);
        return wrapper;
    }

    private static String serializeError(Throwable error) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = error;
        while (cause != null) {
            sb.append(cause.getMessage());
            if ((cause = cause.getCause()) == null) continue;
            sb.append(" : ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="trxGuard")
    private Map.Entry<String, DataModificationContext> allocateTrx(String txId) {
        Lock lock = this.trxGuard.writeLock();
        try {
            Map.Entry<String, DataModificationContext> ret;
            lock.lock();
            if (txId == null) {
                UUID uuid = UUID.randomUUID();
                ret = this.allocateTransactionInternal(uuid);
            } else {
                UUID uuid = UUID.fromString(txId);
                ret = this.txmap.containsKey(uuid.toString()) ? new AbstractMap.SimpleEntry<String, DataModificationContext>(txId, (DataModificationContext)this.txmap.get(txId)) : this.allocateTransactionInternal(uuid);
            }
            Map.Entry<String, DataModificationContext> entry = ret;
            return entry;
        }
        finally {
            lock.unlock();
        }
    }

    private Map.Entry<String, DataModificationContext> allocateTransactionInternal(UUID uuid) {
        DataModificationContext ctx = new DataModificationContext(this.transactionFactory);
        AbstractMap.SimpleEntry<String, DataModificationContext> ret = new AbstractMap.SimpleEntry<String, DataModificationContext>(uuid.toString(), ctx);
        this.txmap.put(uuid.toString(), ctx);
        return ret;
    }

    @Override
    public void close() {
        this.scheduledExecutorService.shutdown();
        this.cleanerFuture.cancel(true);
        this.txmap.clear();
        this.dataChangeRegistry.close();
    }

    @Override
    public ListenerKey addListener(int store, String entity, JsonElement path) throws IOException {
        return this.addListener(store, entity, path, null);
    }

    @Override
    public ListenerKey addListener(String store, String entity, JsonElement path) throws IOException {
        return this.addListener(Util.store2int(store), entity, path);
    }

    @Override
    public ListenerKey addListener(String store, String entity, JsonElement path, String transport) throws IOException {
        return this.addListener(Util.store2int(store), entity, path, transport);
    }

    @Override
    public ListenerKey addListener(int store, String entity, JsonElement path, String transport) throws IOException {
        return this.dataChangeRegistry.createListener(this.path2II(path), Util.int2store(store), transport);
    }

    @Override
    public boolean deleteListener(String uri, String name) {
        return this.dataChangeRegistry.removeListener(uri, name);
    }
}

