/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcNotificationMessage;
import org.opendaylight.jsonrpc.model.JSONRPCArg;
import org.opendaylight.jsonrpc.model.NotificationState;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConverter {
    private static final String JSON_IO_ERROR = "I/O problem in JSON codec";
    private static final char COLON = ':';
    private static final Logger LOG = LoggerFactory.getLogger(JsonConverter.class);
    private static final JSONRPCArg EMPTY_RPC_ARG = new JSONRPCArg(null, null);
    private static final JsonParser PARSER = new JsonParser();
    private static final JSONCodecFactorySupplier CODEC_SUPPLIER = JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02;
    private final SchemaContext schemaContext;

    public JsonConverter(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public DOMNotification notificationConvert(JsonRpcNotificationMessage notification, Map<String, NotificationState> mappedNotifications) {
        JsonObject digested;
        JsonElement parsed;
        String method = notification.getMethod();
        LOG.debug("Got notification {}", (Object)notification);
        if (!mappedNotifications.containsKey(method)) {
            LOG.error("Notification not mapped {}", (Object)method);
            return null;
        }
        NotificationState ns = mappedNotifications.get(method);
        try {
            parsed = (JsonElement)notification.getParamsAsObject(JsonElement.class);
        }
        catch (JsonRpcException e) {
            LOG.error("Error processing notification", (Throwable)e);
            return null;
        }
        if (parsed.isJsonObject()) {
            digested = parsed.getAsJsonObject();
        } else if (parsed.isJsonArray()) {
            digested = new JsonObject();
            ArrayList childNodes = new ArrayList(ns.notification().getChildNodes());
            for (int i = 0; i < childNodes.size() && i < parsed.getAsJsonArray().size(); ++i) {
                digested.add(((DataSchemaNode)childNodes.get(i)).getQName().getLocalName(), parsed.getAsJsonArray().get(i));
            }
        } else {
            digested = new JsonObject();
            LOG.warn("Invalid JSON in payload will be ignored : {}", (Object)parsed);
        }
        DataContainerNodeAttrBuilder notificationBuilder = ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)ns.notification().getQName()));
        DOMNotification deserialized = this.extractNotification(ns, (JsonElement)digested, (DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode>)notificationBuilder);
        LOG.debug("Deserialized {}", (Object)deserialized);
        return deserialized;
    }

    /*
     * Exception decompiling
     */
    private DOMNotification extractNotification(NotificationState notificationState, JsonElement jsonResult, DataContainerNodeAttrBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> notificationBuilder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public NormalizedNode<?, ?> rpcInputConvert(RpcDefinition def, JsonObject input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public NormalizedNode<?, ?> rpcOutputConvert(RpcDefinition def, JsonObject input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JsonObject rpcConvert(SchemaPath path, ContainerNode data) {
        LOG.debug("Converting node {} at path {}", (Object)data, (Object)path);
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = JsonWriterFactory.createJsonWriter((Writer)writer);
        NormalizedNodeStreamWriter streamWriter = JSONNormalizedNodeStreamWriter.createNestedWriter((JSONCodecFactory)CODEC_SUPPLIER.getShared(this.schemaContext), (SchemaPath)path, null, (JsonWriter)jsonWriter);
        NormalizedNodeWriter nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);
        try {
            jsonWriter.beginObject();
            for (DataContainerChild child : data.getValue()) {
                nodeWriter.write((NormalizedNode)child);
            }
            jsonWriter.endObject();
            jsonWriter.flush();
            JsonObject dataWithModule = PARSER.parse(writer.toString()).getAsJsonObject();
            JsonObject newData = new JsonObject();
            for (Map.Entry element : dataWithModule.entrySet()) {
                String property = (String)element.getKey();
                int idx = ((String)element.getKey()).indexOf(58);
                if (idx != -1) {
                    newData.add(property.substring(idx + 1), (JsonElement)element.getValue());
                    continue;
                }
                newData.add(property, (JsonElement)element.getValue());
            }
            return newData;
        }
        catch (IOException e) {
            LOG.error(JSON_IO_ERROR, (Throwable)e);
            return null;
        }
    }

    private JsonObject doConvert(List<QName> qnames, NormalizedNode<?, ?> data) {
        if (!qnames.isEmpty()) {
            return this.doConvert(SchemaPath.create(qnames, (boolean)true), data);
        }
        return this.doConvert(SchemaPath.ROOT, data);
    }

    private JsonObject doConvert(SchemaPath schemaPath, NormalizedNode<?, ?> data) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = JsonWriterFactory.createJsonWriter((Writer)writer);
        JSONCodecFactory codecFactory = CODEC_SUPPLIER.getShared(this.schemaContext);
        NormalizedNodeStreamWriter jsonStream = data instanceof MapEntryNode ? JSONNormalizedNodeStreamWriter.createNestedWriter((JSONCodecFactory)codecFactory, (SchemaPath)schemaPath, null, (JsonWriter)jsonWriter) : JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)codecFactory, (SchemaPath)schemaPath, null, (JsonWriter)jsonWriter);
        NormalizedNodeWriter nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)jsonStream);
        try {
            nodeWriter.write(data);
            nodeWriter.flush();
            String jsonValue = writer.toString();
            if (!jsonValue.startsWith("{")) {
                jsonValue = "{" + jsonValue + "}";
            }
            if (data instanceof LeafNode) {
                jsonValue = jsonValue + '}';
            }
            return PARSER.parse(jsonValue).getAsJsonObject();
        }
        catch (IOException e) {
            LOG.error(JSON_IO_ERROR, (Throwable)e);
            return null;
        }
    }

    public String makeQualifiedName(Module module, QName qname) {
        return module.getName() + ':' + qname.getLocalName();
    }

    private Module getModule(QNameModule nameModule) {
        Optional possibleModule = this.schemaContext.findModule(nameModule.getNamespace(), nameModule.getRevision());
        Preconditions.checkState((boolean)possibleModule.isPresent(), (String)"Could not find module for namespace %s and revision %s", (Object)nameModule.getNamespace(), (Object)nameModule.getRevision());
        return (Module)possibleModule.get();
    }

    public JSONRPCArg toBusWithStripControl(YangInstanceIdentifier path, @Nullable NormalizedNode<?, ?> data, boolean strip) {
        String rootKey;
        QName nodeType;
        YangInstanceIdentifier.PathArgument root;
        JsonObject tracker;
        JsonObject pathJson;
        Iterator pathIterator = path.getPathArguments().iterator();
        ArrayList<QName> qnames = new ArrayList<QName>();
        boolean topLevel = true;
        JsonElement dataJson = null;
        if (pathIterator.hasNext()) {
            pathJson = new JsonObject();
            tracker = new JsonObject();
            root = (YangInstanceIdentifier.PathArgument)pathIterator.next();
            nodeType = root.getNodeType();
            if (pathIterator.hasNext()) {
                qnames.add(nodeType);
            }
        } else {
            return EMPTY_RPC_ARG;
        }
        Module possibleModule = this.getModule(nodeType.getModule());
        String activeModule = possibleModule.getName();
        String lastKey = rootKey = this.makeQualifiedName(possibleModule, root.getNodeType());
        pathJson.add(rootKey, (JsonElement)tracker);
        JsonObject previous = tracker;
        while (pathIterator.hasNext()) {
            YangInstanceIdentifier.PathArgument pathArg = (YangInstanceIdentifier.PathArgument)pathIterator.next();
            JsonObject nextLevel = new JsonObject();
            if (pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                Map keyValues = ((YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArg).getKeyValues();
                for (Map.Entry entry : keyValues.entrySet()) {
                    nextLevel.add(((QName)entry.getKey()).getLocalName(), (JsonElement)new JsonPrimitive(entry.getValue().toString()));
                }
                JsonArray jsonArray = new JsonArray();
                jsonArray.add((JsonElement)nextLevel);
                lastKey = pathArg.getNodeType().getLocalName();
                if (topLevel) {
                    pathJson.remove(rootKey);
                    pathJson.add(rootKey, (JsonElement)jsonArray);
                } else {
                    previous.remove(lastKey);
                    previous.add(lastKey, (JsonElement)jsonArray);
                }
            } else {
                if (pathIterator.hasNext()) {
                    qnames.add(pathArg.getNodeType());
                }
                lastKey = pathArg.getNodeType().getLocalName();
                tracker.add(lastKey, (JsonElement)nextLevel);
            }
            previous = tracker;
            tracker = nextLevel;
            topLevel = false;
        }
        if (data != null) {
            dataJson = this.toBusData(data, strip, qnames, lastKey, activeModule);
        }
        return new JSONRPCArg((JsonElement)pathJson, dataJson);
    }

    private JsonElement toBusData(NormalizedNode<?, ?> data, boolean strip, List<QName> qnames, String lastKey, String activeModule) {
        JsonObject newData = this.doConvert(qnames, data);
        Object dataJson = newData == null ? null : (!newData.has(lastKey) ? (!newData.has(activeModule + ':' + lastKey) ? newData : this.decideStrip(newData, activeModule + ':' + lastKey, strip)) : this.decideStrip(newData, lastKey, strip));
        return dataJson;
    }

    private JsonElement decideStrip(JsonObject data, String outerElement, boolean strip) {
        return strip ? data.get(outerElement) : data;
    }

    public JSONRPCArg toBus(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        return this.toBusWithStripControl(path, data, true);
    }

    public JsonObject fromBus(YangInstanceIdentifier path, JsonElement jsonElement) {
        Iterator it = path.getPathArguments().iterator();
        if (!it.hasNext()) {
            return null;
        }
        YangInstanceIdentifier.PathArgument pathArg = (YangInstanceIdentifier.PathArgument)it.next();
        QName nodeType = pathArg.getNodeType();
        Module possibleModule = this.getModule(nodeType.getModule());
        while (it.hasNext()) {
            pathArg = (YangInstanceIdentifier.PathArgument)it.next();
        }
        String rootKey = this.makeQualifiedName(possibleModule, pathArg.getNodeType());
        JsonObject result = new JsonObject();
        if (pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            JsonArray asArray = new JsonArray();
            if (jsonElement != null && !jsonElement.isJsonNull()) {
                asArray.add(jsonElement);
            }
            result.add(rootKey, (JsonElement)asArray);
        } else if (jsonElement != null && !jsonElement.isJsonNull()) {
            result.add(rootKey, jsonElement);
        } else {
            result.add(rootKey, (JsonElement)new JsonObject());
        }
        return result;
    }

    private SchemaNode findParentSchema(YangInstanceIdentifier yii) {
        DataSchemaContextNode child = (DataSchemaContextNode)DataSchemaContextTree.from((SchemaContext)this.schemaContext).findChild(yii).orElseThrow(() -> new IllegalStateException("No such child : " + yii));
        Object parentSchema = SchemaPath.ROOT.equals((Object)child.getDataSchemaNode().getPath().getParent()) ? this.schemaContext : SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)child.getDataSchemaNode().getPath().getParent());
        return parentSchema;
    }

    public NormalizedNode<?, ?> jsonElementToNormalizedNode(JsonElement data, YangInstanceIdentifier path) {
        return this.jsonElementToNormalizedNode(data, path, false);
    }

    public NormalizedNode<?, ?> jsonElementToNormalizedNode(JsonElement data, YangInstanceIdentifier path, boolean wrap) {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        SchemaNode parentSchema = this.findParentSchema(path);
        try (JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)writer, (JSONCodecFactory)CODEC_SUPPLIER.getShared(this.schemaContext), (SchemaNode)parentSchema);){
            JsonReader reader = new JsonReader((Reader)new StringReader((wrap ? this.wrapReducedJson(path, data) : data).toString()));
            jsonParser.parse(reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to close JsonParserStream", e);
        }
        NormalizedNode result = resultHolder.getResult();
        if (result instanceof MapNode) {
            result = (NormalizedNode)Iterables.getOnlyElement((Iterable)((MapNode)result).getValue());
        }
        LOG.debug("Parsed result : {}", (Object)result);
        return result;
    }

    private JsonElement wrapReducedJson(YangInstanceIdentifier id, JsonElement data) {
        QName qname = id.getLastPathArgument().getNodeType();
        JsonObject wrapper = new JsonObject();
        String elName = qname.getLocalName();
        JsonArray arr = new JsonArray();
        arr.add(data);
        wrapper.add(elName, (JsonElement)arr);
        return wrapper;
    }
}

