/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Queues;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.model.ModuleInfo;
import org.opendaylight.jsonrpc.model.RemoteGovernance;
import org.opendaylight.jsonrpc.model.SchemaContextProvider;
import org.opendaylight.jsonrpc.model.StringYangTextSchemaSource;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.Peer;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.reactor.RFC7950Reactors;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ASTSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToASTTransformer;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceSchemaContextProvider
implements SchemaContextProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GovernanceSchemaContextProvider.class);
    private final RemoteGovernance governance;
    private final LoadingCache<ModuleInfo, Set<ModuleImport>> moduleImportCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ModuleInfo, Set<ModuleImport>>(){

        public Set<ModuleImport> load(ModuleInfo key) throws Exception {
            LOG.trace("Resolving imports of {}", (Object)key);
            String content = GovernanceSchemaContextProvider.this.fetchModuleSource(key);
            ASTSchemaSource schemaSource = TextToASTTransformer.transformText((YangTextSchemaSource)new StringYangTextSchemaSource(key.getModule(), content));
            return schemaSource.getDependencyInformation().getDependencies();
        }
    });

    public GovernanceSchemaContextProvider(@Nonnull RemoteGovernance governance) {
        this.governance = (RemoteGovernance)Preconditions.checkNotNull((Object)governance);
    }

    @Override
    public SchemaContext createSchemaContext(Peer peer) {
        try {
            return this.createInternal(peer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to build SchemaContext", e);
        }
    }

    private SchemaContext createInternal(Peer peer) throws ReactorException {
        CrossSourceStatementReactor.BuildAction reactor = RFC7950Reactors.defaultReactor().newBuild();
        ArrayDeque toResolve = Queues.newArrayDeque();
        try {
            peer.getModules().forEach(mod -> {
                LOG.trace("Resolving dependencies of '{}'", (Object)mod.getValue());
                toResolve.addAll(this.governance.depends(mod.getValue(), null));
            });
        }
        catch (Exception e) {
            LOG.warn("Governance failed to provide dependencies, will attempt to resolve it locally", (Throwable)e);
            HashSet<ModuleInfo> resolved = new HashSet<ModuleInfo>();
            toResolve.clear();
            toResolve.addAll(peer.getModules().stream().map(yi -> {
                if (yi.getValue().indexOf(64) != -1) {
                    String[] parts = yi.getValue().split("@");
                    return new ModuleInfo(parts[0], parts[1]);
                }
                return new ModuleInfo(yi.getValue(), null);
            }).collect(Collectors.toList()));
            while (!toResolve.isEmpty()) {
                ModuleInfo mi = (ModuleInfo)toResolve.pop();
                Set imports = ((Set)this.moduleImportCache.getUnchecked((Object)mi)).stream().map(imp -> new ModuleInfo(imp.getModuleName(), null)).filter(m -> !resolved.contains(m)).filter(m -> !toResolve.contains(m)).collect(Collectors.toSet());
                resolved.add(mi);
                toResolve.addAll(imports);
                LOG.trace("Remaining to resolve : {}", (Object)toResolve);
            }
        }
        toResolve.forEach(m -> {
            String source = this.fetchModuleSource((ModuleInfo)m);
            this.addSourceToReactor(reactor, m.getModule(), source);
        });
        return reactor.buildEffective();
    }

    private void addSourceToReactor(CrossSourceStatementReactor.BuildAction reactor, String name, String yangSource) {
        try {
            reactor.addSource((StatementStreamSource)YangStatementStreamSource.create((YangTextSchemaSource)YangTextSchemaSource.delegateForByteSource((String)(name + ".yang"), (ByteSource)ByteSource.wrap((byte[])yangSource.getBytes(StandardCharsets.UTF_8)))));
        }
        catch (IOException | YangSyntaxErrorException e) {
            throw new IllegalStateException("Unable to add source of '" + name + "' into reactor", e);
        }
    }

    private String fetchModuleSource(ModuleInfo mi) {
        LOG.trace("Fetching yang model '{}'", (Object)mi.getModule());
        return Optional.ofNullable(this.governance.source(mi.getModule())).orElseThrow(() -> new IllegalArgumentException("Module not found in governance : " + mi.getModule()));
    }
}

