/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import org.opendaylight.jsonrpc.model.TransactionFactory;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.spi.ForwardingDOMDataWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

class EnsureParentTransactionFactory
implements TransactionFactory {
    private final SchemaContext schemaContext;
    protected final DOMDataBroker domDataBroker;

    EnsureParentTransactionFactory(DOMDataBroker domDataBroker, SchemaContext schemaContext) {
        this.domDataBroker = domDataBroker;
        this.schemaContext = schemaContext;
    }

    @Override
    public DOMDataTreeWriteTransaction get() {
        final DOMDataTreeWriteTransaction delegateTx = this.domDataBroker.newWriteOnlyTransaction();
        return new ForwardingDOMDataWriteTransaction(){

            public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
                YangInstanceIdentifier parentPath = path.getParent();
                if (parentPath != null) {
                    NormalizedNode parentNode = ImmutableNodes.fromInstanceId((SchemaContext)EnsureParentTransactionFactory.this.schemaContext, (YangInstanceIdentifier)parentPath);
                    this.delegate().merge(store, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{parentNode.getIdentifier()}), parentNode);
                }
                super.merge(store, path, data);
            }

            protected DOMDataTreeWriteTransaction delegate() {
                return delegateTx;
            }
        };
    }
}

