/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.model.TransactionFactory;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;

public class DataModificationContext
implements AutoCloseable {
    private List<Throwable> errors = Collections.emptyList();
    private final List<DOMDataTreeWriteTransaction> txs = new ArrayList<DOMDataTreeWriteTransaction>();
    private final AtomicLong completed = new AtomicLong(-1L);

    public DataModificationContext(@Nonnull TransactionFactory transactionFactory) {
        Objects.requireNonNull(transactionFactory);
        this.txs.add((DOMDataTreeWriteTransaction)transactionFactory.get());
    }

    public DOMDataTreeWriteTransaction newWriteTransaction() {
        return this.txs.get(0);
    }

    public boolean cancel() {
        try {
            if (this.txs.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.txs.stream().allMatch(DOMDataTreeWriteTransaction::cancel);
            return bl;
        }
        finally {
            this.completed.set(System.currentTimeMillis());
        }
    }

    public boolean submit() {
        try {
            if (this.txs.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.errors = this.txs.stream().map(DataModificationContext::extractError).flatMap(o -> o.isPresent() ? Stream.of(o.get()) : Stream.empty()).collect(Collectors.toList());
            boolean bl = this.errors.isEmpty();
            return bl;
        }
        finally {
            this.completed.set(System.currentTimeMillis());
        }
    }

    public boolean isSuccess() {
        return this.errors.isEmpty();
    }

    public long getCompletionTimestamp() {
        return this.completed.get();
    }

    public void addError(Throwable ex) {
        this.errors.add(ex);
    }

    @Nonnull
    public List<Throwable> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    private static Optional<Throwable> extractError(DOMDataTreeWriteTransaction tx) {
        try {
            tx.commit().get();
            return Optional.empty();
        }
        catch (InterruptedException | ExecutionException e) {
            return Optional.of(e);
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "DataModificationContext [errors=" + this.errors + ", txs=" + this.txs + "]";
    }
}

