/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.bus.api.PeerContext;
import org.opendaylight.jsonrpc.bus.messagelib.PeerContextHolder;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.impl.DataChangeListenerRegistration;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.model.DataChangeNotificationPublisher;
import org.opendaylight.jsonrpc.model.ListenerKey;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class DataChangeListenerRegistry
implements AutoCloseable {
    private final Map<ListenerKey, DataChangeListenerRegistration> listenerMap = Maps.newConcurrentMap();
    private final DOMDataBroker domDataBroker;
    private final TransportFactory transportFactory;
    private final JsonConverter jsonConverter;

    public DataChangeListenerRegistry(@Nonnull DOMDataBroker domDataBroker, @Nonnull TransportFactory transportFactory, @Nonnull JsonConverter jsonConverter) {
        this.domDataBroker = Objects.requireNonNull(domDataBroker);
        this.transportFactory = Objects.requireNonNull(transportFactory);
        this.jsonConverter = Objects.requireNonNull(jsonConverter);
    }

    public ListenerKey createListener(YangInstanceIdentifier path, LogicalDatastoreType store, String transport) throws IOException {
        ListenerKey response = new ListenerKey(this.allocateUri(transport), UUID.randomUUID().toString());
        try {
            DataChangeNotificationPublisher publisher = (DataChangeNotificationPublisher)this.transportFactory.endpointBuilder().publisher().createProxy(DataChangeNotificationPublisher.class, response.getUri());
            this.listenerMap.put(response, new DataChangeListenerRegistration(path, this.listenerMap::remove, this.domDataBroker, this.jsonConverter, store, publisher, response));
            return response;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean removeListener(String uri, String name) {
        DataChangeListenerRegistration listener = this.listenerMap.get(new ListenerKey(uri, name));
        if (listener != null) {
            listener.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.listenerMap.values().stream().forEach(DataChangeListenerRegistration::close);
        this.listenerMap.clear();
    }

    private String allocateUri(String transport) throws IOException {
        try (Socket socket = new Socket();){
            socket.bind(null);
            PeerContext peer = PeerContextHolder.get();
            String string = String.format("%s://%s:%d", transport != null ? transport : peer.transport(), ((InetSocketAddress)peer.channel().localAddress()).getAddress().getHostAddress(), socket.getLocalPort());
            return string;
        }
    }
}

