/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.impl;

import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.jsonrpc.bus.messagelib.SubscriberSession;
import org.opendaylight.jsonrpc.bus.messagelib.TransportFactory;
import org.opendaylight.jsonrpc.impl.JsonConverter;
import org.opendaylight.jsonrpc.impl.YangInstanceIdentifierDeserializer;
import org.opendaylight.jsonrpc.model.DataChangeNotification;
import org.opendaylight.jsonrpc.model.DataChangeNotificationPublisher;
import org.opendaylight.jsonrpc.model.DataTreeCandidateImpl;
import org.opendaylight.jsonrpc.model.JSONRPCArg;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class DOMDataTreeChangeListenerAdapter
implements DataChangeNotificationPublisher,
AutoCloseable {
    private final DOMDataTreeChangeListener listener;
    private final SubscriberSession session;
    private final JsonConverter converter;
    private final SchemaContext schemaContext;

    public DOMDataTreeChangeListenerAdapter(@Nonnull DOMDataTreeChangeListener delegate, @Nonnull TransportFactory transportFactory, String uri, @Nonnull JsonConverter converter, @Nonnull SchemaContext schemaContext) throws URISyntaxException {
        Objects.requireNonNull(transportFactory);
        this.converter = Objects.requireNonNull(converter);
        this.listener = Objects.requireNonNull(delegate);
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.session = transportFactory.endpointBuilder().subscriber().create(uri, (AutoCloseable)this);
    }

    @Override
    public void close() {
        this.session.close();
    }

    @Override
    public void notifyListener(DataChangeNotification change) {
        LinkedHashSet<DataTreeCandidateImpl> changes = new LinkedHashSet<DataTreeCandidateImpl>();
        for (JSONRPCArg c : change.getChanges()) {
            YangInstanceIdentifier yii = YangInstanceIdentifierDeserializer.toYangInstanceIdentifier(c.getPath(), this.schemaContext);
            NormalizedNode<?, ?> data = this.converter.jsonElementToNormalizedNode(c.getData(), yii);
            changes.add(new DataTreeCandidateImpl(yii, data));
        }
        this.listener.onDataTreeChanged(changes);
    }
}

