/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.hmap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.opendaylight.jsonrpc.hmap.PathCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonPathCodec
implements PathCodec<JsonElement, String> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathCodec.class);
    private static final JsonPathCodec INSTANCE = new JsonPathCodec();

    private JsonPathCodec() {
    }

    public static JsonPathCodec create() {
        return INSTANCE;
    }

    @Override
    public Iterable<String> serialize(JsonElement path) {
        LinkedList<String> list = new LinkedList<String>();
        this.serializeObject(path, list);
        return list;
    }

    private void serializeObject(JsonElement path, LinkedList<String> list) {
        LOG.trace("Current node [OBJECT]: {}", (Object)path);
        for (Map.Entry e : path.getAsJsonObject().entrySet()) {
            String currentNode = (String)e.getKey();
            JsonElement el = (JsonElement)e.getValue();
            if (el instanceof JsonObject) {
                list.addLast(currentNode);
                this.serializeObject((JsonElement)e.getValue(), list);
                continue;
            }
            if (el instanceof JsonArray) {
                list.addLast(currentNode);
                this.serializeArray((JsonElement)e.getValue(), list);
                continue;
            }
            this.serializeLeaf(currentNode, (JsonElement)e.getValue(), list);
        }
    }

    private void serializeLeaf(String currentNode, JsonElement path, LinkedList<String> list) {
        LOG.trace("Current node [LEAF  ]: {}", (Object)path);
        list.addLast(currentNode + "=" + path.getAsJsonPrimitive().getAsString());
    }

    private void serializeArray(JsonElement path, LinkedList<String> list) {
        LOG.trace("Current node [ARRAY ]: {}", (Object)path);
        JsonArray arr = (JsonArray)path;
        for (JsonElement je : arr) {
            if (je instanceof JsonObject) {
                this.serializeObject(je, list);
                continue;
            }
            this.throwJsonPathError(je);
        }
    }

    private void throwJsonPathError(JsonElement je) {
        throw new IllegalStateException("Unexpected JSON element " + je);
    }

    @Override
    public JsonElement deserialize(Iterable<String> path) {
        JsonObject root;
        JsonObject current = root = new JsonObject();
        JsonObject prev = null;
        String last = null;
        Iterator<String> it = path.iterator();
        if (it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            String p = it.next();
            int eqIdx = p.indexOf(61);
            if (eqIdx != -1) {
                String part1 = p.substring(0, eqIdx);
                String part2 = p.substring(eqIdx + 1);
                JsonArray arr = new JsonArray();
                JsonObject el = new JsonObject();
                el.add(part1, (JsonElement)new JsonPrimitive(part2));
                arr.add((JsonElement)el);
                prev.add(last, (JsonElement)arr);
                current = el;
                continue;
            }
            JsonObject node = new JsonObject();
            prev = current;
            current.add(p, (JsonElement)node);
            current = node;
            last = p;
        }
        return root;
    }
}

