/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.hmap;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.jsonrpc.hmap.EnumTreeNode;
import org.opendaylight.jsonrpc.hmap.HierarchicalEnumMap;
import org.opendaylight.jsonrpc.hmap.PathCodec;

public final class HierarchicalEnumHashMap<P, K extends Enum<K>, D, I>
implements HierarchicalEnumMap<P, K, D> {
    private final EnumTreeNode<I, K, D> root;
    private final PathCodec<P, I> pathCodec;

    private HierarchicalEnumHashMap(Class<K> keyType, PathCodec<P, I> pathSupplier) {
        this.pathCodec = Objects.requireNonNull(pathSupplier);
        this.root = HierarchicalEnumHashMap.newRootNode(Objects.requireNonNull(keyType));
    }

    public static <P, K extends Enum<K>, D, I> HierarchicalEnumMap<P, K, D> create(Class<K> keyType, PathCodec<P, I> pathSupplier) {
        return new HierarchicalEnumHashMap<P, K, D, I>(keyType, pathSupplier);
    }

    @Override
    public Optional<D> lookup(P path, K key) {
        EnumTreeNode<I, K, D> current = this.root;
        Object value = null;
        Iterator<I> iterator = this.pathCodec.serialize(path).iterator();
        if (!iterator.hasNext()) {
            return Optional.ofNullable(this.root.value(key));
        }
        while (iterator.hasNext()) {
            Optional<EnumTreeNode<I, K, D>> candidate;
            I id = iterator.next();
            if (current.value(key) != null) {
                value = current.value(key);
            }
            if ((candidate = current.lookupChild(id)).isPresent()) {
                current = candidate.get();
                if (current.value(key) == null) continue;
                value = current.value(key);
                continue;
            }
            current = current.appendChild(id);
        }
        return Optional.ofNullable(value);
    }

    @Override
    public D put(P path, K key, D data) {
        EnumTreeNode<I, K, D> current = this.root;
        for (I id : this.pathCodec.serialize(path)) {
            Optional<EnumTreeNode<I, K, D>> candidate = current.lookupChild(id);
            current = candidate.isPresent() ? candidate.get() : current.appendChild(id);
        }
        D previousValue = current.value(key);
        current.setValue(key, data);
        return previousValue;
    }

    @Override
    public Map<P, D> toMap(K key) {
        HashMap map = new HashMap();
        LinkedList currentPath = new LinkedList();
        this.collectChildren(this.root, key, currentPath, map);
        return Collections.unmodifiableMap(map);
    }

    private void collectChildren(EnumTreeNode<I, K, D> current, K key, LinkedList<I> currentPath, Map<P, D> map) {
        LinkedList<I> newPath = new LinkedList<I>(currentPath);
        newPath.addLast(current.id());
        D value = current.value(key);
        if (value != null) {
            P path = this.pathCodec.deserialize(newPath);
            map.put(path, value);
        }
        for (EnumTreeNode<I, K, D> child : current.children()) {
            this.collectChildren(child, key, newPath, map);
        }
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        this.append(sb, this.root, 1);
        return sb.toString();
    }

    private void append(StringBuilder sb, EnumTreeNode<I, K, D> node, int level) {
        sb.append(Strings.repeat((String)" ", (int)(level * 2)));
        sb.append(node.id()).append("[").append(node.allValues()).append("]");
        sb.append("\n");
        for (EnumTreeNode<I, K, D> child : node.children()) {
            this.append(sb, child, level + 1);
        }
    }

    private static <I, K extends Enum<K>, D> RootTreeNode<I, K, D> newRootNode(Class<K> keyType) {
        return new RootTreeNode(keyType);
    }

    private static abstract class AbstractTreeNode<I, K extends Enum<K>, D>
    implements EnumTreeNode<I, K, D> {
        private final I id;
        private final Map<I, EnumTreeNode<I, K, D>> children;
        private final EnumMap<K, D> value;
        private final Class<K> keyType;

        private AbstractTreeNode(I id, Class<K> keyType) {
            this.id = id;
            this.children = new ConcurrentHashMap<I, EnumTreeNode<I, K, D>>();
            this.value = new EnumMap(keyType);
            this.keyType = keyType;
        }

        @Override
        public I id() {
            return this.id;
        }

        @Override
        public Collection<EnumTreeNode<I, K, D>> children() {
            return Collections.unmodifiableCollection(this.children.values());
        }

        @Override
        public Optional<EnumTreeNode<I, K, D>> lookupChild(I childId) {
            return Optional.ofNullable(this.children.get(childId));
        }

        @Override
        public void setValue(K key, D data) {
            this.value.put(key, data);
        }

        @Override
        public D value(K key) {
            return this.value.get(key);
        }

        @Override
        public Map<K, D> allValues() {
            return Collections.unmodifiableMap(this.value);
        }

        @Override
        public EnumTreeNode<I, K, D> appendChild(I childId) {
            EnumTreeNode<I, K, D> child = AbstractTreeNode.newNode(childId, this.keyType, this);
            this.children.put(childId, child);
            return child;
        }

        private static <I, K extends Enum<K>, D> EnumTreeNode<I, K, D> newNode(I id, Class<K> keyType, EnumTreeNode<I, K, D> parent) {
            return new ChildTreeNode<I, K, D>(id, keyType, parent);
        }
    }

    private static class RootTreeNode<I, K extends Enum<K>, D>
    extends AbstractTreeNode<I, K, D> {
        RootTreeNode(Class<K> keyType) {
            super(null, keyType);
        }
    }

    private static class ChildTreeNode<I, K extends Enum<K>, D>
    extends AbstractTreeNode<I, K, D> {
        ChildTreeNode(I id, Class<K> keyType, EnumTreeNode<I, K, D> parent) {
            super(id, keyType);
        }
    }
}

