/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.Reflection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.jsonrpc.binding.ControllerRpcInvocationAdapter;
import org.opendaylight.jsonrpc.binding.EmbeddedBusSessionFactoryProvider;
import org.opendaylight.jsonrpc.binding.EmbeddedRpcInvocationAdapter;
import org.opendaylight.jsonrpc.binding.InboundHandler;
import org.opendaylight.jsonrpc.binding.MultiModelBuilder;
import org.opendaylight.jsonrpc.binding.MultiModelProxy;
import org.opendaylight.jsonrpc.binding.MultiModelRequestDispatcher;
import org.opendaylight.jsonrpc.binding.OutboundHandler;
import org.opendaylight.jsonrpc.binding.ProxyContext;
import org.opendaylight.jsonrpc.binding.RpcInvocationAdapter;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactoryProvider;
import org.opendaylight.jsonrpc.bus.messagelib.AbstractTransportFactory;
import org.opendaylight.jsonrpc.bus.messagelib.BaseSession;
import org.opendaylight.jsonrpc.bus.messagelib.NoopReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.ReplyMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequestMessageHandler;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.jsonrpc.bus.messagelib.ResponderSession;
import org.opendaylight.jsonrpc.bus.spi.EventLoopConfiguration;
import org.opendaylight.jsonrpc.bus.spi.EventLoopGroupProvider;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaAwareTransportFactory
extends AbstractTransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareTransportFactory.class);
    private final Map<Object, ProxyContext<? extends RpcService>> proxyMap = Maps.newConcurrentMap();
    private final RpcInvocationAdapter invocationAdapter;

    private SchemaAwareTransportFactory(RpcInvocationAdapter invocationAdapter, EventLoopConfiguration eventLoopConfiguration) {
        super((BusSessionFactoryProvider)new EmbeddedBusSessionFactoryProvider(eventLoopConfiguration));
        this.invocationAdapter = Objects.requireNonNull(invocationAdapter);
    }

    public SchemaAwareTransportFactory(ControllerRpcInvocationAdapter invocationAdapter, BusSessionFactoryProvider busSessionFactoryProvider) {
        super(busSessionFactoryProvider);
        this.invocationAdapter = Objects.requireNonNull(invocationAdapter);
    }

    public <T extends RpcService> ProxyContext<T> createBindingRequesterProxy(Class<T> type, String uri) throws URISyntaxException {
        LOG.info("Creating requester proxy for type {} against endpoint '{}'", (Object)type.getName(), (Object)uri);
        RequesterSession requester = this.createRequester(uri, (ReplyMessageHandler)NoopReplyMessageHandler.INSTANCE);
        OutboundHandler<T> handler = new OutboundHandler<T>(type, this.invocationAdapter, requester);
        RpcService proxy = (RpcService)Reflection.newProxy(type, handler);
        ObjectRegistration<RpcService> rpcReg = this.invocationAdapter.registerImpl(type, proxy);
        ProxyContext<RpcService> context = new ProxyContext<RpcService>(type, rpcReg, (BaseSession)requester, proxy, this::closeProxy);
        this.proxyMap.put(proxy, context);
        return context;
    }

    public MultiModelProxy createMultiModelRequesterProxy(Set<Class<? extends RpcService>> services, String uri) throws URISyntaxException {
        HashSet<ProxyContext<RpcService>> proxies = new HashSet<ProxyContext<RpcService>>();
        for (Class<? extends RpcService> service : services) {
            proxies.add(this.createBindingRequesterProxy(service, uri));
        }
        return new MultiModelProxy(proxies);
    }

    private void closeProxy(Object proxy) {
        ProxyContext<? extends RpcService> context = this.proxyMap.remove(proxy);
        if (context != null) {
            context.closeInternal();
        }
    }

    public <T extends RpcService> ResponderSession createResponder(Class<T> type, T rpcImpl, String bindUri) throws URISyntaxException {
        LOG.info("Creating responder type {} exposed on '{}'", (Object)type.getName(), (Object)bindUri);
        URI uri = new URI(bindUri);
        return this.getMessageLibraryForTransport(uri.getScheme()).responder(bindUri, new InboundHandler<T>(type, this.invocationAdapter, rpcImpl), false);
    }

    public ResponderSession createMultiModelResponder(MultiModelBuilder builder, String bindUri) throws URISyntaxException {
        ClassToInstanceMap<RpcService> services = builder.build();
        LOG.info("Creating multi-model responder for services {} exposed on '{}'", (Object)services.keySet(), (Object)bindUri);
        URI uri = new URI(bindUri);
        Set<InboundHandler<RpcService>> handlers = services.entrySet().stream().map(e -> new InboundHandler<RpcService>((Class)e.getKey(), this.invocationAdapter, (RpcService)e.getValue())).collect(Collectors.toSet());
        return this.getMessageLibraryForTransport(uri.getScheme()).responder(bindUri, (RequestMessageHandler)new MultiModelRequestDispatcher(handlers), false);
    }

    public void close() {
        this.proxyMap.values().stream().forEach(ProxyContext::close);
        this.proxyMap.clear();
        super.close();
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<SchemaAwareTransportFactory> {
        private EventLoopConfiguration eventLoopConfiguration;
        private RpcInvocationAdapter rpcInvocationAdapter;

        public Builder withRpcInvocationAdapter(RpcInvocationAdapter rpcInvocationAdapter) {
            this.rpcInvocationAdapter = rpcInvocationAdapter;
            return this;
        }

        public Builder withEventLoopConfig(EventLoopConfiguration eventLoopConfiguration) {
            this.eventLoopConfiguration = eventLoopConfiguration;
            return this;
        }

        public SchemaAwareTransportFactory build() {
            if (this.eventLoopConfiguration == null) {
                this.eventLoopConfiguration = EventLoopGroupProvider.config();
            }
            if (this.rpcInvocationAdapter == null) {
                this.rpcInvocationAdapter = EmbeddedRpcInvocationAdapter.INSTANCE;
            }
            return new SchemaAwareTransportFactory(this.rpcInvocationAdapter, this.eventLoopConfiguration);
        }
    }
}

