/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import java.util.function.Consumer;
import org.opendaylight.jsonrpc.bus.messagelib.BaseSession;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;

public class ProxyContext<T extends RpcService>
implements AutoCloseable {
    private final ObjectRegistration<T> rpcRegistration;
    private final BaseSession session;
    private final T proxy;
    private final Consumer<T> cleanCallback;
    private final Class<T> type;

    ProxyContext(Class<T> type, ObjectRegistration<T> rpcRegistration, BaseSession session, T proxy, Consumer<T> cleanCallback) {
        this.rpcRegistration = rpcRegistration;
        this.session = session;
        this.proxy = proxy;
        this.cleanCallback = cleanCallback;
        this.type = type;
    }

    public T getProxy() {
        return this.proxy;
    }

    @Override
    public void close() {
        this.cleanCallback.accept(this.proxy);
    }

    public Class<T> getType() {
        return this.type;
    }

    void closeInternal() {
        this.session.close();
        this.rpcRegistration.close();
    }
}

