/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.opendaylight.jsonrpc.binding.AbstractHandler;
import org.opendaylight.jsonrpc.binding.RpcInvocationAdapter;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.messagelib.RequesterSession;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundHandler<T extends RpcService>
extends AbstractHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundHandler.class);
    private final RequesterSession session;

    public OutboundHandler(Class<T> type, RpcInvocationAdapter adapter, RequesterSession session) {
        super(type, adapter);
        this.session = session;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.handleInvocationInternal(method, args);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, e.getMessage()).build());
        }
        catch (Exception e) {
            LOG.error("Error while invoking RPC method", (Throwable)e);
            return Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, e.getMessage()).build());
        }
    }

    private Object handleInvocationInternal(Method method, Object[] args) {
        JsonObject request;
        Preconditions.checkArgument((args.length < 2 ? 1 : 0) != 0, (String)"Unexpected number of arguments : %d", (int)args.length);
        RpcDefinition rpcDef = (RpcDefinition)this.rpcMethodMap.get((Object)method);
        Preconditions.checkNotNull((Object)rpcDef);
        if (args.length == 1) {
            ContainerNode domData = this.adapter.codec().toNormalizedNodeRpcData((DataContainer)args[0]);
            request = this.adapter.converter().get().rpcConvert(rpcDef.getInput().getPath(), domData);
        } else {
            request = null;
        }
        JsonRpcReplyMessage reply = this.session.sendRequestAndReadReply(rpcDef.getQName().getLocalName(), request);
        if (reply.isError()) {
            return Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, reply.getError().getMessage()).build());
        }
        ParameterizedType futureType = (ParameterizedType)method.getGenericReturnType();
        ParameterizedType rpcResultType = (ParameterizedType)futureType.getActualTypeArguments()[0];
        if (rpcResultType.getActualTypeArguments()[0].equals(Void.class)) {
            return Futures.immediateFuture((Object)RpcResultBuilder.success().build());
        }
        JsonObject wrapper = new JsonObject();
        wrapper.add("output", (JsonElement)this.wrapResponse(reply.getResult(), rpcDef));
        NormalizedNode<?, ?> nn = this.adapter.converter().get().rpcOutputConvert(rpcDef, wrapper);
        DataObject result = this.adapter.codec().fromNormalizedNodeRpcData(rpcDef.getOutput().getPath(), (ContainerNode)nn);
        LOG.debug("Deserialized : {}", (Object)result);
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)result).build());
    }

    private JsonObject wrapResponse(JsonElement unwrapped, RpcDefinition def) {
        if (unwrapped instanceof JsonPrimitive) {
            DataSchemaNode node = (DataSchemaNode)def.getOutput().getChildNodes().iterator().next();
            JsonObject ret = new JsonObject();
            ret.add(node.getQName().getLocalName(), unwrapped);
            return ret;
        }
        if (unwrapped instanceof JsonArray) {
            if (unwrapped.getAsJsonArray().size() != def.getOutput().getChildNodes().size()) {
                Preconditions.checkArgument((unwrapped.getAsJsonArray().size() == def.getOutput().getChildNodes().size() ? 1 : 0) != 0, (String)"Can't wrap positional arguments. Expected %d, given %d", (int)def.getOutput().getChildNodes().size(), (int)unwrapped.getAsJsonArray().size());
            }
            JsonObject ret = new JsonObject();
            int counter = 0;
            for (DataSchemaNode node : def.getOutput().getChildNodes()) {
                ret.add(node.getQName().getLocalName(), unwrapped.getAsJsonArray().get(counter++));
            }
            return ret;
        }
        if (unwrapped instanceof JsonObject) {
            return unwrapped.getAsJsonObject();
        }
        return new JsonObject();
    }
}

