/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import java.util.Optional;
import java.util.Set;
import org.opendaylight.jsonrpc.binding.InboundHandler;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessage;
import org.opendaylight.jsonrpc.bus.messagelib.RequestMessageHandler;
import org.opendaylight.yangtools.yang.binding.RpcService;

public class MultiModelRequestDispatcher
implements RequestMessageHandler {
    private final Set<InboundHandler<RpcService>> handlers;

    MultiModelRequestDispatcher(Set<InboundHandler<RpcService>> handlers) {
        this.handlers = handlers;
    }

    public void handleRequest(JsonRpcRequestMessage request, JsonRpcReplyMessage.Builder replyBuilder) {
        Optional<InboundHandler> handler = this.handlers.stream().filter(h -> h.hasMethod(request.getMethod())).findFirst();
        if (handler.isPresent()) {
            handler.get().handleRequest(request, replyBuilder);
        } else {
            replyBuilder.error(new JsonRpcErrorObject(Integer.valueOf(-32601), "No such method : " + request.getMethod(), null));
        }
    }
}

