/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.jsonrpc.binding.ProxyContext;
import org.opendaylight.yangtools.yang.binding.RpcService;

public class MultiModelProxy
implements AutoCloseable {
    private final ClassToInstanceMap<? extends RpcService> proxyMap;
    private final Set<ProxyContext<RpcService>> proxies;

    public MultiModelProxy(Set<ProxyContext<RpcService>> proxies) {
        this.proxies = proxies;
        this.proxyMap = ImmutableClassToInstanceMap.copyOf(proxies.stream().collect(Collectors.toMap(ProxyContext::getType, ProxyContext::getProxy)));
    }

    @Override
    public void close() {
        this.proxies.stream().forEach(ProxyContext::close);
    }

    public <T extends RpcService> T getRpcService(Class<T> type) {
        return (T)((RpcService)Objects.requireNonNull(this.proxyMap.get(type), "Service is not supported by this requester instance : " + type));
    }
}

