/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.RpcService;

public final class MultiModelBuilder
implements Builder<ClassToInstanceMap<RpcService>> {
    private final ClassToInstanceMap<RpcService> services = MutableClassToInstanceMap.create();

    private MultiModelBuilder() {
    }

    public static MultiModelBuilder create() {
        return new MultiModelBuilder();
    }

    public <T extends RpcService> MultiModelBuilder addService(Class<T> type, T impl) {
        this.services.put(type, impl);
        return this;
    }

    public ClassToInstanceMap<RpcService> build() {
        Preconditions.checkState((!this.services.isEmpty() ? 1 : 0) != 0, (Object)"No services defined");
        return ImmutableClassToInstanceMap.copyOf(this.services);
    }
}

