/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import org.opendaylight.jsonrpc.binding.AbstractHandler;
import org.opendaylight.jsonrpc.binding.RpcInvocationAdapter;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessage;
import org.opendaylight.jsonrpc.bus.messagelib.RequestMessageHandler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.jsonrpc.rev161201.ResponseErrorCode;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundHandler<T extends RpcService>
extends AbstractHandler<T>
implements RequestMessageHandler {
    private static final String INPUT = "input";
    private static final Logger LOG = LoggerFactory.getLogger(InboundHandler.class);
    private final T impl;

    public InboundHandler(Class<T> type, RpcInvocationAdapter adapter, T impl) {
        super(type, adapter);
        this.impl = (RpcService)Objects.requireNonNull(impl);
    }

    private Optional<Map.Entry<RpcDefinition, Method>> findMethod(String methodName) {
        return this.rpcMethodMap.inverse().entrySet().stream().filter(e -> ((RpcDefinition)e.getKey()).getQName().getLocalName().equals(methodName)).findFirst();
    }

    public void handleRequest(JsonRpcRequestMessage request, JsonRpcReplyMessage.Builder replyBuilder) {
        try {
            JsonObject wrapper;
            Map.Entry<RpcDefinition, Method> rpcDefEntry = this.findMethod(request.getMethod()).orElseThrow(() -> new NoSuchMethodError(request.getMethod()));
            if (request.getParams() instanceof JsonArray) {
                wrapper = this.wrapArrayInput((JsonArray)request.getParams(), rpcDefEntry.getKey());
            } else if (request.getParams() instanceof JsonPrimitive) {
                wrapper = this.wrapPrimitiveInput((JsonPrimitive)request.getParams(), rpcDefEntry.getKey());
            } else {
                wrapper = new JsonObject();
                wrapper.add(INPUT, request.getParams());
            }
            Method method = rpcDefEntry.getValue();
            Object[] args = this.convertArguments(rpcDefEntry, wrapper, method);
            Future output = (Future)method.invoke(this.impl, args);
            LOG.debug("Output : {}", (Object)output);
            RpcResult rpcResult = (RpcResult)Futures.getUnchecked((Future)output);
            if (rpcResult.isSuccessful()) {
                if (rpcResult.getResult() != null) {
                    ContainerNode domData = this.adapter.codec().toNormalizedNodeRpcData((DataContainer)rpcResult.getResult());
                    JsonObject reply = this.adapter.converter().get().rpcConvert(rpcDefEntry.getKey().getOutput().getPath(), domData);
                    replyBuilder.result((JsonElement)reply);
                }
            } else {
                this.mapRpcError(replyBuilder, (RpcResult<Object>)rpcResult);
            }
        }
        catch (NoSuchMethodError e) {
            this.logRpcInvocationFailure(e);
            replyBuilder.error(new JsonRpcErrorObject(Integer.valueOf(ResponseErrorCode.MethodNotFound.getIntValue()), "No such method : " + e.getMessage(), (JsonElement)JsonNull.INSTANCE));
        }
        catch (IllegalArgumentException e) {
            this.logRpcInvocationFailure(e);
            replyBuilder.error(new JsonRpcErrorObject(Integer.valueOf(ResponseErrorCode.InvalidParams.getIntValue()), e.getMessage(), (JsonElement)JsonNull.INSTANCE));
        }
        catch (Exception e) {
            this.logRpcInvocationFailure(e);
            replyBuilder.error(new JsonRpcErrorObject(Integer.valueOf(ResponseErrorCode.InternalError.getIntValue()), e.getMessage(), (JsonElement)JsonNull.INSTANCE));
        }
    }

    private void mapRpcError(JsonRpcReplyMessage.Builder replyBuilder, RpcResult<Object> rpcResult) {
        Collection errors = rpcResult.getErrors();
        if (errors.isEmpty()) {
            replyBuilder.error(new JsonRpcErrorObject((JsonElement)new JsonPrimitive("No error info available")));
        } else if (errors.size() == 1) {
            RpcError error = (RpcError)errors.iterator().next();
            replyBuilder.error(new JsonRpcErrorObject(this.mapError(error)));
        } else {
            JsonArray arr = new JsonArray(errors.size());
            errors.stream().map(this::mapError).forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
            replyBuilder.error(new JsonRpcErrorObject((JsonElement)arr));
        }
    }

    private Object[] convertArguments(Map.Entry<RpcDefinition, Method> rpcDefEntry, JsonObject wrapper, Method method) {
        Object[] args;
        if (method.getParameterCount() == 1) {
            if (wrapper.get(INPUT).isJsonNull()) {
                wrapper.add(INPUT, (JsonElement)new JsonObject());
            }
            NormalizedNode<?, ?> nn = this.adapter.converter().get().rpcOutputConvert(rpcDefEntry.getKey(), wrapper);
            DataObject dataObject = this.adapter.codec().fromNormalizedNodeRpcData(rpcDefEntry.getKey().getInput().getPath(), (ContainerNode)nn);
            LOG.debug("Input : {}", (Object)dataObject);
            args = new Object[]{dataObject};
        } else {
            args = null;
        }
        return args;
    }

    private void logRpcInvocationFailure(Throwable cause) {
        LOG.error("RPC invocation failed", cause);
    }

    private JsonObject wrapPrimitiveInput(JsonPrimitive request, RpcDefinition rpcDef) {
        JsonObject wrapper = new JsonObject();
        DataSchemaNode node = (DataSchemaNode)rpcDef.getInput().getChildNodes().iterator().next();
        JsonObject prop = new JsonObject();
        prop.add(node.getQName().getLocalName(), (JsonElement)request);
        wrapper.add(INPUT, (JsonElement)prop);
        return wrapper;
    }

    private JsonObject wrapArrayInput(JsonArray inputArr, RpcDefinition rpcDef) {
        JsonObject wrapper = new JsonObject();
        JsonObject prop = new JsonObject();
        Iterator it = rpcDef.getInput().getChildNodes().iterator();
        int counter = 0;
        if (inputArr.size() > rpcDef.getInput().getChildNodes().size()) {
            LOG.warn("Extra parameter(s) provided, expected : {}, given : {}", (Object)rpcDef.getInput().getChildNodes().size(), (Object)inputArr.size());
        }
        while (it.hasNext() && counter < inputArr.size()) {
            prop.add(((DataSchemaNode)it.next()).getQName().getLocalName(), inputArr.get(counter++));
        }
        wrapper.add(INPUT, (JsonElement)prop);
        return wrapper;
    }

    private JsonElement mapError(RpcError rpcError) {
        JsonObject wrapper = new JsonObject();
        JsonObject data = new JsonObject();
        wrapper.add("data", (JsonElement)data);
        wrapper.add("code", (JsonElement)new JsonPrimitive((Number)ResponseErrorCode.InternalError.getIntValue()));
        wrapper.add("message", (JsonElement)(rpcError.getMessage() == null ? JsonNull.INSTANCE : new JsonPrimitive(rpcError.getMessage())));
        return wrapper;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        return null;
    }

    boolean hasMethod(String methodName) {
        return this.findMethod(methodName).isPresent();
    }
}

