/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.EventListener;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMSchemaServiceExtension;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

public final class EmbeddedSchemaService
implements DOMSchemaService {
    private final ListenerRegistry<SchemaContextListener> listeners = ListenerRegistry.create();
    private final SchemaContext schemaContext;

    public EmbeddedSchemaService(SchemaContext schemaContext) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
    }

    public SchemaContext getSessionContext() {
        return this.schemaContext;
    }

    public SchemaContext getGlobalContext() {
        return this.schemaContext;
    }

    public ListenerRegistration<SchemaContextListener> registerSchemaContextListener(SchemaContextListener listener) {
        listener.onGlobalContextUpdated(this.schemaContext);
        return this.listeners.register((EventListener)listener);
    }

    public @NonNull ClassToInstanceMap<DOMSchemaServiceExtension> getExtensions() {
        return ImmutableClassToInstanceMap.of();
    }
}

