/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.binding;

import javassist.ClassPool;
import org.opendaylight.jsonrpc.binding.EmbeddedSchemaService;
import org.opendaylight.jsonrpc.binding.RpcInvocationAdapter;
import org.opendaylight.jsonrpc.impl.SchemaChangeAwareConverter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerGenerator;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.StreamWriterGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.ModuleInfoBackedContext;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.broker.DOMRpcRouter;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;

public final class EmbeddedRpcInvocationAdapter
implements RpcInvocationAdapter {
    private static final ClassPool CLASS_POOL = ClassPool.getDefault();
    private static final ClassLoadingStrategy CLS = GeneratedClassLoadingStrategy.getTCCLClassLoadingStrategy();
    private final BindingToNormalizedNodeCodec codec;
    private final EmbeddedSchemaService schemaService;
    private final SchemaChangeAwareConverter converter;
    private final DOMRpcRouter rpcService;
    private final BindingDOMRpcProviderServiceAdapter rpcAdapter;
    public static final EmbeddedRpcInvocationAdapter INSTANCE = new EmbeddedRpcInvocationAdapter();

    private EmbeddedRpcInvocationAdapter() {
        DataObjectSerializerGenerator generator = StreamWriterGenerator.create((JavassistUtils)JavassistUtils.forClassPool((ClassPool)CLASS_POOL));
        BindingNormalizedNodeCodecRegistry codecRegistry = new BindingNormalizedNodeCodecRegistry(generator);
        this.codec = new BindingToNormalizedNodeCodec(CLS, codecRegistry);
        ModuleInfoBackedContext moduleContext = ModuleInfoBackedContext.create();
        moduleContext.addModuleInfos((Iterable)BindingReflections.loadModuleInfos());
        SchemaContext schemaContext = (SchemaContext)moduleContext.tryToCreateSchemaContext().get();
        this.schemaService = new EmbeddedSchemaService(schemaContext);
        this.converter = new SchemaChangeAwareConverter(this.schemaService);
        this.schemaService.registerSchemaContextListener((SchemaContextListener)this.codec);
        this.rpcService = new DOMRpcRouter();
        this.rpcService.onGlobalContextUpdated(schemaContext);
        this.schemaService.registerSchemaContextListener((SchemaContextListener)this.rpcService);
        this.rpcAdapter = new BindingDOMRpcProviderServiceAdapter(this.rpcService.getRpcProviderService(), this.codec);
    }

    @Override
    public SchemaChangeAwareConverter converter() {
        return this.converter;
    }

    @Override
    public BindingToNormalizedNodeCodec codec() {
        return this.codec;
    }

    @Override
    public <T extends RpcService> ObjectRegistration<T> registerImpl(Class<T> type, T impl) {
        return this.rpcAdapter.registerRpcImplementation(type, impl);
    }

    @Override
    public SchemaContext schemaContext() {
        return this.schemaService.getGlobalContext();
    }
}

